/*
 * Decompiled with CFR 0.152.
 */
package simtools.diagram;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import simtools.diagram.DiagramConnection;
import simtools.diagram.DiagramConnector;
import simtools.diagram.DiagramSelectedShape;
import simtools.diagram.DiagramSelectionListener;
import simtools.diagram.Resizable;
import simtools.util.ListenerManager;

public class DiagramSelection
extends Rectangle {
    private boolean _selArea = false;
    private Vector _selectedShapes;
    private Hashtable _selectedShapesMap;
    private Vector _shapes = null;
    private Hashtable _connectionShapes;
    private Hashtable _connectionShapesTranslation;
    private int _grid;
    private ListenerManager _listeners = new ListenerManager();

    public DiagramSelection() {
        this._selectedShapes = new Vector();
        this._selectedShapesMap = new Hashtable();
        this._connectionShapes = new Hashtable();
        this._connectionShapesTranslation = new Hashtable();
        this.width = -1;
        this._grid = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propagate() {
        ListenerManager listenerManager = this._listeners;
        synchronized (listenerManager) {
            int n = this._listeners.size();
            for (int i = 0; i < n; ++i) {
                DiagramSelectionListener diagramSelectionListener = (DiagramSelectionListener)this._listeners.get(i);
                if (diagramSelectionListener == null) continue;
                diagramSelectionListener.selectionChanged(this);
            }
        }
    }

    public void addListener(DiagramSelectionListener diagramSelectionListener) {
        this._listeners.add(diagramSelectionListener);
    }

    public void removeListener(DiagramSelectionListener diagramSelectionListener) {
        this._listeners.remove(diagramSelectionListener);
    }

    public void removeAllListeners() {
        this._listeners.clear();
    }

    public void setShapes(Vector vector) {
        this._shapes = vector;
    }

    public boolean isSelected(Shape shape) {
        return this._selectedShapesMap.containsKey(shape);
    }

    public boolean isSelected(int n, int n2) {
        for (int i = 0; i < this._selectedShapes.size(); ++i) {
            DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(i);
            Shape shape = diagramSelectedShape.s;
            if (!shape.contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this._selectedShapes.isEmpty();
    }

    public boolean isSizing() {
        return this._selArea;
    }

    public void unselect() {
        this.clear();
        this._selArea = false;
        this.width = -1;
        this.propagate();
    }

    public boolean selectPoint(int n, int n2) {
        this.clear();
        this._selArea = false;
        this.width = -1;
        boolean bl = this.addShapeAt(n, n2);
        this.propagate();
        return bl;
    }

    public boolean selectAll() {
        this.clear();
        this._selArea = false;
        this.width = -1;
        boolean bl = this.addAllShapes();
        this.propagate();
        return bl;
    }

    public int getShapeCount() {
        return this._selectedShapes.size();
    }

    public Shape getShape(int n) {
        DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(n);
        return diagramSelectedShape.s;
    }

    public DiagramSelectedShape getSelectedShape(int n) {
        return (DiagramSelectedShape)this._selectedShapes.elementAt(n);
    }

    public void removeShapeAt(int n) {
        DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(n);
        this._selectedShapes.removeElementAt(n);
        this._selectedShapesMap.remove(diagramSelectedShape.s);
    }

    public boolean addPoint(int n, int n2) {
        int n3;
        this._selArea = false;
        this.width = -1;
        for (n3 = 0; n3 < this._selectedShapes.size(); ++n3) {
            DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(n3);
            Shape shape = diagramSelectedShape.s;
            if (!shape.contains(n, n2)) continue;
            this._selectedShapes.removeElementAt(n3);
            this._selectedShapesMap.remove(shape);
            return true;
        }
        n3 = this.addShapeAt(n, n2) ? 1 : 0;
        this.propagate();
        return n3 != 0;
    }

    public boolean selectArea(int n, int n2, int n3, int n4) {
        this._selArea = true;
        this.clear();
        if (n3 < 0) {
            this.x = n + n3;
            this.width = -n3;
        } else {
            this.x = n;
            this.width = n3;
        }
        if (n4 < 0) {
            this.y = n2 + n4;
            this.height = -n4;
        } else {
            this.y = n2;
            this.height = n4;
        }
        boolean bl = this.addShapesInside();
        this.propagate();
        return bl;
    }

    public boolean selectAreaEnd() {
        if (this._selArea) {
            this._selArea = false;
            this.width = -1;
            return true;
        }
        return false;
    }

    public void setGrid(int n) {
        this._grid = n < 0 ? 0 : n;
    }

    public int getGrid() {
        return this._grid;
    }

    public int gridPosition(int n) {
        if (this._grid == 0) {
            return n;
        }
        int n2 = n % this._grid;
        if (n2 > this._grid / 2) {
            return n + this._grid - n2;
        }
        return n - n2;
    }

    public Vector getSelection() {
        Vector<Shape> vector = new Vector<Shape>(this._selectedShapes.size());
        for (int i = 0; i < this._selectedShapes.size(); ++i) {
            DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(i);
            vector.addElement(diagramSelectedShape.s);
        }
        return vector;
    }

    public Vector copySelection(Point point) {
        Vector<Shape> vector = new Vector<Shape>(this._selectedShapes.size());
        this._connectionShapes.clear();
        for (int i = 0; i < this._selectedShapes.size(); ++i) {
            DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(i);
            Shape shape = diagramSelectedShape.s;
            if (shape instanceof DiagramConnection) continue;
            DiagramConnector diagramConnector = null;
            if (shape instanceof DiagramConnector && (diagramConnector = (DiagramConnector)((Object)shape)).connectorOwner() != null) continue;
            Shape shape2 = this.copyShape(shape);
            if (shape2 != null) {
                this.translateShape(shape2, -point.x, -point.y);
                vector.addElement(shape2);
            }
            if (diagramConnector == null || shape2 == null) continue;
            DiagramConnector diagramConnector2 = (DiagramConnector)((Object)shape2);
            Enumeration enumeration = diagramConnector.getConnections();
            if (enumeration == null) continue;
            while (enumeration.hasMoreElements()) {
                DiagramConnection diagramConnection = (DiagramConnection)enumeration.nextElement();
                DiagramConnector diagramConnector3 = (DiagramConnector)this._connectionShapes.get(diagramConnection);
                if (diagramConnector3 != null) {
                    Shape shape3 = null;
                    shape3 = diagramConnection.input() == diagramConnector || diagramConnection.input().connectorOwner() == diagramConnector ? this.copyConnectionShape((Shape)((Object)diagramConnection), diagramConnector2, diagramConnector3) : this.copyConnectionShape((Shape)((Object)diagramConnection), diagramConnector3, diagramConnector2);
                    if (shape3 != null) {
                        vector.addElement(shape3);
                    }
                    this._connectionShapes.remove(diagramConnection);
                    continue;
                }
                this._connectionShapes.put(diagramConnection, diagramConnector2);
            }
        }
        return vector;
    }

    public void deleteSelection() {
        for (int i = 0; i < this._selectedShapes.size(); ++i) {
            DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(i);
            this.deleteShape(diagramSelectedShape.s);
        }
        this.unselect();
    }

    public void alignSelection() {
        Object object;
        Object object2;
        this._connectionShapes.clear();
        this._connectionShapesTranslation.clear();
        for (int i = 0; i < this._selectedShapes.size(); ++i) {
            Enumeration enumeration;
            object2 = (DiagramSelectedShape)this._selectedShapes.elementAt(i);
            object = ((DiagramSelectedShape)object2).s;
            if (object instanceof DiagramConnection) continue;
            DiagramConnector diagramConnector = null;
            if (object instanceof DiagramConnector && (diagramConnector = (DiagramConnector)object).connectorOwner() != null) continue;
            Point point = ((DiagramSelectedShape)object2).p;
            Point point2 = ((DiagramSelectedShape)object2).pd;
            int n = this.gridPosition(point.x) - point2.x;
            int n2 = this.gridPosition(point.y) - point2.y;
            if (diagramConnector != null && (enumeration = diagramConnector.getConnections()) != null) {
                while (enumeration.hasMoreElements()) {
                    DiagramConnection diagramConnection = (DiagramConnection)enumeration.nextElement();
                    DiagramConnector diagramConnector2 = (DiagramConnector)this._connectionShapes.get(diagramConnection);
                    if (diagramConnector2 != null) {
                        Point point3 = (Point)this._connectionShapesTranslation.get(diagramConnection);
                        if (point3.x != n || point3.y != n2) {
                            this.translateConnectionShape((Shape)((Object)diagramConnection), diagramConnector2, point3.x, point3.y);
                            this.translateConnectionShape((Shape)((Object)diagramConnection), diagramConnector, n, n2);
                        } else {
                            this.translateShape((Shape)((Object)diagramConnection), n, n2);
                        }
                        this._connectionShapes.remove(diagramConnection);
                        continue;
                    }
                    this._connectionShapes.put(diagramConnection, diagramConnector);
                    this._connectionShapesTranslation.put(diagramConnection, new Point(n, n2));
                }
            }
            this.translateShape((Shape)object, n, n2);
            point2.x += n;
            point2.y += n2;
            point.x = point2.x;
            point.y = point2.y;
        }
        Enumeration enumeration = this._connectionShapes.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (DiagramConnection)enumeration.nextElement();
            object = (Point)this._connectionShapesTranslation.get(object2);
            this.translateConnectionShape((Shape)object2, (DiagramConnector)this._connectionShapes.get(object2), ((Point)object).x, ((Point)object).y);
        }
    }

    public int checkResizeWay(int n, int n2) {
        Resizable resizable = null;
        for (int i = 0; i < this._selectedShapes.size(); ++i) {
            DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(i);
            Shape shape = diagramSelectedShape.s;
            if (shape instanceof Resizable) {
                if (resizable == null) {
                    resizable = (Resizable)((Object)shape);
                } else {
                    return 0;
                }
            }
            if (shape instanceof DiagramConnection) {
                return 0;
            }
            if (!(shape instanceof DiagramConnector)) continue;
            return 0;
        }
        if (resizable != null) {
            Rectangle2D rectangle2D = ((Shape)((Object)resizable)).getBounds2D();
            rectangle2D.setFrame(rectangle2D.getX() + 5.0, rectangle2D.getY() + 5.0, rectangle2D.getWidth() - 10.0, rectangle2D.getHeight() - 10.0);
            int n3 = rectangle2D.outcode(n, n2);
            switch (n3) {
                case 2: {
                    return 1;
                }
                case 6: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 12: {
                    return 4;
                }
                case 8: {
                    return 5;
                }
                case 9: {
                    return 6;
                }
                case 1: {
                    return 7;
                }
                case 3: {
                    return 8;
                }
            }
        }
        return 0;
    }

    public void resizeSelection(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        switch (n3) {
            case 1: 
            case 5: {
                n = 0;
                break;
            }
            case 3: 
            case 7: {
                n2 = 0;
            }
        }
        boolean bl = true;
        for (int i = 0; i < this._selectedShapes.size(); ++i) {
            DiagramSelectedShape diagramSelectedShape = (DiagramSelectedShape)this._selectedShapes.elementAt(i);
            Shape shape = diagramSelectedShape.s;
            if (!(shape instanceof Resizable)) continue;
            Point point = diagramSelectedShape.p;
            Point point2 = diagramSelectedShape.pd;
            point.x += n;
            point.y += n2;
            if (bl) {
                n4 = this.gridPosition(point.x) - point2.x;
                n5 = this.gridPosition(point.y) - point2.y;
                bl = false;
            }
            Rectangle rectangle = shape.getBounds();
            switch (n3) {
                case 1: {
                    this.resizeShape(shape, 0, -n5);
                    break;
                }
                case 2: {
                    this.resizeShape(shape, n4, -n5);
                    break;
                }
                case 3: {
                    this.resizeShape(shape, n4, 0);
                    break;
                }
                case 4: {
                    this.resizeShape(shape, n4, n5);
                    break;
                }
                case 5: {
                    this.resizeShape(shape, 0, n5);
                    break;
                }
                case 6: {
                    this.resizeShape(shape, -n4, n5);
                    break;
                }
                case 7: {
                    this.resizeShape(shape, -n4, 0);
                    break;
                }
                case 8: {
                    this.resizeShape(shape, -n4, -n5);
                }
            }
            Rectangle rectangle2 = shape.getBounds();
            int n6 = rectangle2.width - rectangle.width;
            int n7 = rectangle2.height - rectangle.height;
            switch (n3) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.translateShape(shape, 0, n7);
                    break;
                }
                case 5: {
                    this.translateShape(shape, 0, n7);
                    break;
                }
                case 6: {
                    this.translateShape(shape, -n6, n7);
                    break;
                }
                case 7: {
                    this.translateShape(shape, -n6, 0);
                    break;
                }
                case 8: {
                    this.translateShape(shape, -n6, 0);
                }
            }
            point2.x += n4;
            point2.y += n5;
        }
    }

    public void translateSelection(int n, int n2) {
        Object object;
        int n3 = 0;
        int n4 = 0;
        this._connectionShapes.clear();
        boolean bl = true;
        for (int i = 0; i < this._selectedShapes.size(); ++i) {
            Enumeration enumeration;
            object = (DiagramSelectedShape)this._selectedShapes.elementAt(i);
            Shape shape = ((DiagramSelectedShape)object).s;
            if (shape instanceof DiagramConnection) continue;
            DiagramConnector diagramConnector = null;
            if (shape instanceof DiagramConnector && (diagramConnector = (DiagramConnector)((Object)shape)).connectorOwner() != null) continue;
            Point point = ((DiagramSelectedShape)object).p;
            Point point2 = ((DiagramSelectedShape)object).pd;
            point.x += n;
            point.y += n2;
            if (bl) {
                n3 = this.gridPosition(point.x) - point2.x;
                n4 = this.gridPosition(point.y) - point2.y;
                bl = false;
            }
            if (diagramConnector != null && (enumeration = diagramConnector.getConnections()) != null) {
                while (enumeration.hasMoreElements()) {
                    DiagramConnection diagramConnection = (DiagramConnection)enumeration.nextElement();
                    if (this._connectionShapes.containsKey(diagramConnection)) {
                        this.translateShape((Shape)((Object)diagramConnection), n3, n4);
                        this._connectionShapes.remove(diagramConnection);
                        continue;
                    }
                    this._connectionShapes.put(diagramConnection, diagramConnector);
                }
            }
            this.translateShape(shape, n3, n4);
            point2.x += n3;
            point2.y += n4;
        }
        Enumeration enumeration = this._connectionShapes.keys();
        while (enumeration.hasMoreElements()) {
            object = (DiagramConnection)enumeration.nextElement();
            this.translateConnectionShape((Shape)object, (DiagramConnector)this._connectionShapes.get(object), n3, n4);
        }
        this.translate(n, n2);
    }

    public Point getShapeOrigin(Shape shape, Point point) {
        Point point2;
        Point point3 = point2 = point == null ? new Point() : point;
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            point2.x = rectangle.x;
            point2.y = rectangle.y;
        } else {
            Rectangle rectangle = shape.getBounds();
            point2.x = rectangle.x;
            point2.y = rectangle.y;
        }
        return point2;
    }

    public void translateShape(Shape shape, int n, int n2) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            rectangle.translate(n, n2);
        }
    }

    public void resizeShape(Shape shape, int n, int n2) {
        if (shape instanceof Resizable) {
            Resizable resizable = (Resizable)((Object)shape);
            resizable.resize(n, n2);
        }
    }

    public void translateConnectionShape(Shape shape, DiagramConnector diagramConnector, int n, int n2) {
    }

    public Shape copyShape(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            return new Rectangle(rectangle);
        }
        return null;
    }

    public Shape copyConnectionShape(Shape shape, DiagramConnector diagramConnector, DiagramConnector diagramConnector2) {
        return null;
    }

    public void deleteShape(Shape shape) {
        if (this._shapes == null) {
            return;
        }
        this._shapes.removeElement(shape);
    }

    protected void clear() {
        this._selectedShapes.clear();
        this._selectedShapesMap.clear();
    }

    protected boolean add(DiagramSelectedShape diagramSelectedShape) {
        if (this._selectedShapesMap.containsKey(diagramSelectedShape.s)) {
            return false;
        }
        this._selectedShapes.addElement(diagramSelectedShape);
        this._selectedShapesMap.put(diagramSelectedShape.s, diagramSelectedShape);
        return true;
    }

    protected boolean addAllShapes() {
        if (this._shapes == null || this._shapes.size() == 0) {
            return false;
        }
        for (int i = 0; i < this._shapes.size(); ++i) {
            Shape shape = (Shape)this._shapes.elementAt(i);
            this.add(new DiagramSelectedShape(shape, this.getShapeOrigin(shape, null)));
        }
        return true;
    }

    protected boolean addShapeAt(int n, int n2) {
        if (this._shapes == null) {
            return false;
        }
        for (int i = 0; i < this._shapes.size(); ++i) {
            Shape shape = (Shape)this._shapes.elementAt(i);
            if (!shape.contains(n, n2)) continue;
            this.add(new DiagramSelectedShape(shape, this.getShapeOrigin(shape, null)));
            return true;
        }
        return false;
    }

    protected boolean addShapesInside() {
        if (this._shapes == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this._shapes.size(); ++i) {
            Shape shape = (Shape)this._shapes.elementAt(i);
            if (!this.contains(shape.getBounds())) continue;
            this.add(new DiagramSelectedShape(shape, this.getShapeOrigin(shape, null)));
            bl = true;
        }
        return bl;
    }
}

