/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jsynoptic.base.Plugin;
import jsynoptic.ui.ExpressionPanel;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.ShapeCreator;
import jsynoptic.ui.SourceTree;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.ui.MenuResourceBundle;
import simtools.ui.ResourceFinder;

public class SourcePanel
extends JTabbedPane
implements ActionListener {
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$jsynoptic$ui$SourcePanel == null ? (class$jsynoptic$ui$SourcePanel = SourcePanel.class$("jsynoptic.ui.SourcePanel")) : class$jsynoptic$ui$SourcePanel);
    protected SourceTree sourceTree;
    protected JList shapeList;
    protected JTextField tfAlias;
    protected JLabel lAlias;
    public static final int SOURCE_MODE = 0;
    public static final int SHAPE_MODE = 1;
    static /* synthetic */ Class class$jsynoptic$ui$SourcePanel;

    public SourcePanel(DataSourcePool dataSourcePool) {
        this.sourceTree = new SourceTree(dataSourcePool);
        JScrollPane jScrollPane = new JScrollPane(this.sourceTree);
        Box box = Box.createHorizontalBox();
        this.lAlias = new JLabel(resources.getStringValue("Alias"));
        box.add(this.lAlias);
        this.tfAlias = new JTextField();
        box.add(this.tfAlias);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)box, "South");
        jPanel.setBorder(new TitledBorder(resources.getStringValue("KnownSources")));
        ExpressionPanel expressionPanel = new ExpressionPanel(this.sourceTree);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)expressionPanel, "South");
        this.add(resources.getStringValue("sources"), jPanel2);
        this.tfAlias.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateAlias();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateAlias();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateAlias();
            }

            private void updateAlias() {
                if (!SourcePanel.this.tfAlias.isEnabled()) {
                    return;
                }
                Object object = SourcePanel.this.sourceTree.getSelectedSourceOrCollection();
                if (object instanceof DataSource) {
                    String string;
                    DataInfo dataInfo = ((DataSource)object).getInformation();
                    String string2 = SourcePanel.this.tfAlias.getText();
                    if (string2.equals("")) {
                        string2 = null;
                    }
                    if (dataInfo != null && ((string = dataInfo.alias) == null && string2 != null || string != null && string2 == null || string != null && !string.equals(string2))) {
                        dataInfo.alias = string2;
                        ((DataSource)object).notifyListenersForInfoChange(dataInfo);
                        SourcePanel.this.tfAlias.getDocument().removeDocumentListener(this);
                        TreeNode treeNode = (TreeNode)SourcePanel.this.sourceTree.getSelectionPath().getLastPathComponent();
                        ((DefaultTreeModel)SourcePanel.this.sourceTree.getModel()).nodeChanged(treeNode);
                        SourcePanel.this.tfAlias.getDocument().addDocumentListener(this);
                        SourcePanel.this.tfAlias.requestFocus();
                    }
                }
            }
        });
        this.sourceTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = SourcePanel.this.sourceTree.getSelectedSourceOrCollection();
                SourcePanel.this.sourceTree.removeTreeSelectionListener(this);
                if (object instanceof DataSource && treeSelectionEvent.isAddedPath()) {
                    SourcePanel.this.tfAlias.setEnabled(true);
                    SourcePanel.this.lAlias.setEnabled(true);
                    SourcePanel.this.tfAlias.setEditable(true);
                    String string = DataInfo.getAlias(object);
                    SourcePanel.this.tfAlias.setText(string == null ? "" : string);
                    SourcePanel.this.tfAlias.requestFocus();
                } else {
                    SourcePanel.this.tfAlias.setEnabled(false);
                    SourcePanel.this.lAlias.setEnabled(false);
                    SourcePanel.this.tfAlias.setEditable(false);
                    SourcePanel.this.tfAlias.setText("");
                }
                SourcePanel.this.sourceTree.addTreeSelectionListener(this);
            }
        });
        this.tfAlias.setEnabled(false);
        this.tfAlias.setEditable(false);
        this.lAlias.setEnabled(false);
        Vector<ShapeCreator> vector = new Vector<ShapeCreator>();
        Object[] objectArray = JSynoptic.gui.getPlugins().iterator();
        while (objectArray.hasNext()) {
            Plugin plugin = (Plugin)objectArray.next();
            String[] stringArray = plugin.getShapes();
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(new ShapeCreator(stringArray[i], plugin));
            }
        }
        objectArray = vector.toArray();
        Arrays.sort(objectArray);
        this.shapeList = new JList<Object>(objectArray);
        this.shapeList.setDragEnabled(true);
        jScrollPane = new JScrollPane(this.shapeList);
        this.add(resources.getStringValue("shapes"), jScrollPane);
    }

    public int getMode() {
        int n = this.getSelectedIndex();
        return n == -1 ? 0 : n;
    }

    public SourceTree getSourceTree() {
        return this.sourceTree;
    }

    public Object getSelection() {
        if (this.getMode() == 0) {
            return this.sourceTree.getSelectedSourceOrCollection();
        }
        return this.shapeList.getSelectedValue();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

