/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Polygon;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.Abstract2DShape;
import jsynoptic.builtin.LinesShape;
import jsynoptic.ui.JSynoptic;
import simtools.shapes.AbstractShape;
import simtools.ui.ActionRadioButton;
import simtools.ui.ResourceFinder;

public class PolygonShape
extends Abstract2DShape {
    static final long serialVersionUID = 6306591085331108840L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$PolygonShape == null ? (class$jsynoptic$builtin$PolygonShape = PolygonShape.class$("jsynoptic.builtin.PolygonShape")) : class$jsynoptic$builtin$PolygonShape);
    protected transient Polygon polygon;
    protected double[] x;
    protected double[] y;
    protected boolean regular;
    static /* synthetic */ Class class$jsynoptic$builtin$PolygonShape;

    PolygonShape(int n, int n2, int n3, int n4, double[] dArray, double[] dArray2, boolean bl, boolean bl2, double d) {
        super(n, n2, n3, n4);
        this.allowResize = bl;
        this.fixedRatio = bl2;
        this.ratio = d;
        this.x = dArray;
        this.y = dArray2;
        this.regular = false;
        this.updatePolygon();
    }

    public PolygonShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setRegular(7);
        this.allowResize = true;
        this.fixedRatio = true;
        this.ratio = (double)this._w / (double)this._h;
    }

    protected Shape getDelegateShape() {
        return this.polygon;
    }

    public void setRegular(int n) {
        this.x = new double[n];
        this.y = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = Math.cos(Math.PI * 2 * (double)i / (double)n);
            this.y[i] = Math.sin(Math.PI * 2 * (double)i / (double)n);
        }
        this.regular = true;
        this.updatePolygon();
    }

    protected void updatePolygon() {
        int n = Math.min(this.x.length, this.y.length);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this._ox + this._x + (int)Math.round((this.x[i] + 1.0) * (double)(this._w - 1) / 2.0);
            nArray2[i] = this._oy + this._y - 1 - (int)Math.round((this.y[i] + 1.0) * (double)(this._h - 1) / 2.0);
        }
        this.polygon = new Polygon(nArray, nArray2, n);
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this.polygon.translate(n, n2);
    }

    public void setAnchor(int n, int n2) {
        this.polygon.translate(n - this._ox, n2 - this._oy);
        super.setAnchor(n, n2);
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.updatePolygon();
    }

    public Abstract1DShape.PropertiesPanel createPanel() {
        return new PolygonPropertiesPanel();
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getActions(d, d2, object, n);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (n == 1) {
            vector.add(resources.getString("ConvertToLines"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("ConvertToLines"))) {
            LinesShape linesShape = new LinesShape(this._ox, this._oy, this._w, this._h, this.x, this.y, this.allowResize, this.fixedRatio, this.ratio);
            JSynoptic.gui.getActiveContainer().remove(this);
            JSynoptic.gui.getActiveContainer().add(linesShape);
            JSynoptic.gui.getActiveContainer().getComponent().getDiagramSelection().unselect();
            JSynoptic.gui.getActiveContainer().getComponent().repaint(this.getBounds());
            return true;
        }
        return super.doAction(d, d2, object, string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updatePolygon();
    }

    protected AbstractShape cloneShape() {
        PolygonShape polygonShape = (PolygonShape)super.cloneShape();
        polygonShape.updatePolygon();
        return polygonShape;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PolygonPropertiesPanel
    extends Abstract2DShape.PropertiesPanel2D {
        protected JTextArea taPoints;
        protected ButtonGroup bg;
        protected ActionRadioButton rbRegular;
        protected ActionRadioButton rbUser;
        protected JLabel lorder;
        protected JSpinner sporder;
        protected JLabel lpoints;

        public PolygonPropertiesPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createContent(), "Center");
        }

        public JComponent createContent() {
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            this.rbRegular = new ActionRadioButton(this, resources.getString("Regular")){
                private final /* synthetic */ PolygonPropertiesPanel this$1;
                {
                    this.this$1 = polygonPropertiesPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.lorder.setEnabled(this.this$1.rbRegular.isSelected());
                    this.this$1.sporder.setEnabled(this.this$1.rbRegular.isSelected());
                }
            };
            box2.add(this.rbRegular);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbRegular);
            box2 = Box.createHorizontalBox();
            box2.setBorder(BorderFactory.createEtchedBorder());
            this.lorder = new JLabel(resources.getString("Order"));
            box2.add(this.lorder);
            box2.add(Box.createHorizontalGlue());
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
            spinnerNumberModel.setMinimum(new Integer(3));
            spinnerNumberModel.setValue(new Integer(PolygonShape.this.x.length < 3 ? 3 : PolygonShape.this.x.length));
            this.sporder = new JSpinner(spinnerNumberModel);
            box2.add(this.sporder);
            box.add(box2);
            box2 = Box.createHorizontalBox();
            this.rbUser = new ActionRadioButton(this, resources.getString("User-defined")){
                private final /* synthetic */ PolygonPropertiesPanel this$1;
                {
                    this.this$1 = polygonPropertiesPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.lpoints.setEnabled(this.this$1.rbUser.isSelected());
                    this.this$1.taPoints.setEnabled(this.this$1.rbUser.isSelected());
                }
            };
            box2.add(this.rbUser);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            buttonGroup.add(this.rbUser);
            Box box3 = Box.createVerticalBox();
            box3.setBorder(BorderFactory.createEtchedBorder());
            box2 = Box.createHorizontalBox();
            this.lpoints = new JLabel(resources.getString("CouplesOfX,YPoints:"));
            box2.add(this.lpoints);
            box2.add(Box.createHorizontalGlue());
            box3.add(box2);
            this.taPoints = new JTextArea();
            box3.add(new JScrollPane(this.taPoints));
            String string = "";
            for (int i = 0; i < PolygonShape.this.x.length; ++i) {
                string = string + (PolygonShape.this.polygon.xpoints[i] - PolygonShape.this._ox - PolygonShape.this._x);
                string = string + " ";
                string = string + (PolygonShape.this._oy + PolygonShape.this._y - 1 - PolygonShape.this.polygon.ypoints[i]);
                string = string + "\n";
            }
            this.taPoints.setText(string);
            this.taPoints.setRows(5);
            box.add(box3);
            this.rbRegular.setSelected(PolygonShape.this.regular);
            this.rbUser.setSelected(!PolygonShape.this.regular);
            this.rbRegular.apply();
            this.rbUser.apply();
            box.add(super.createContent());
            return box;
        }

        public void updateProperties() {
            super.updateProperties();
            if (this.rbRegular.isSelected()) {
                PolygonShape.this.setRegular(((Number)this.sporder.getValue()).intValue());
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.taPoints.getText(), " ()[]{}'\"\n\t:;,/");
                boolean bl = true;
                Vector<Object> vector = new Vector<Object>();
                Vector<Object> vector2 = new Vector<Object>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (bl) {
                        vector.add(string);
                    } else {
                        vector2.add(string);
                    }
                    bl = !bl;
                }
                int n = vector2.size();
                if (vector.size() != n) {
                    vector.remove(n);
                }
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.NEGATIVE_INFINITY;
                double d3 = Double.POSITIVE_INFINITY;
                double d4 = Double.NEGATIVE_INFINITY;
                int n2 = 0;
                while (n2 < n) {
                    double d5;
                    double d6;
                    try {
                        d6 = Double.parseDouble((String)vector.get(n2));
                        d5 = Double.parseDouble((String)vector2.get(n2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.remove(n2);
                        vector2.remove(n2);
                        --n;
                        continue;
                    }
                    vector.set(n2, new Double(d6));
                    vector2.set(n2, new Double(d5));
                    if (d6 < d) {
                        d = d6;
                    }
                    if (d5 < d3) {
                        d3 = d5;
                    }
                    if (d6 > d2) {
                        d2 = d6;
                    }
                    if (d5 > d4) {
                        d4 = d5;
                    }
                    ++n2;
                }
                double d7 = d2 - d;
                double d8 = d4 - d3;
                if (d7 == 0.0) {
                    d7 = Abstract1DShape.MIN_SIZE;
                }
                if (d8 == 0.0) {
                    d8 = Abstract1DShape.MIN_SIZE;
                }
                if (PolygonShape.this.allowResize) {
                    PolygonShape.this._w = (int)d7;
                    PolygonShape.this._h = (int)d8;
                    if (PolygonShape.this._w < Abstract1DShape.MIN_SIZE) {
                        PolygonShape.this._w = Abstract1DShape.MIN_SIZE;
                    }
                    if (PolygonShape.this._h < Abstract1DShape.MIN_SIZE) {
                        PolygonShape.this._h = Abstract1DShape.MIN_SIZE;
                    }
                }
                PolygonShape.this.x = new double[n];
                PolygonShape.this.y = new double[n];
                for (int i = 0; i < n; ++i) {
                    PolygonShape.this.x[i] = ((Double)vector.get(i) - d) * 2.0 / d7 - 1.0;
                    PolygonShape.this.y[i] = ((Double)vector2.get(i) - d3) * 2.0 / d8 - 1.0;
                }
                PolygonShape.this.ratio = (double)PolygonShape.this._w / (double)PolygonShape.this._h;
                PolygonShape.this.updatePolygon();
            }
        }

        protected String fillColorLabel() {
            return resources.getString("FillPolygon");
        }
    }
}

