/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.Abstract2DShape;
import jsynoptic.ui.SourceTree;
import simtools.data.DataException;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.shapes.AbstractShape;
import simtools.ui.ActionRadioButton;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public class EllipseShape
extends Abstract2DShape {
    static final long serialVersionUID = 6256410262456113545L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$EllipseShape == null ? (class$jsynoptic$builtin$EllipseShape = EllipseShape.class$("jsynoptic.builtin.EllipseShape")) : class$jsynoptic$builtin$EllipseShape);
    public static final int ANGLE_UNIT_DEGREE = 0;
    public static final int ANGLE_UNIT_RADIAN = 1;
    protected int startUnit;
    protected int endUnit;
    protected transient Shape ellipse;
    protected transient DataSource startAngleSource;
    protected transient DataSource endAngleSource;
    protected transient long startAngleSourceIndex;
    protected transient long endAngleSourceIndex;
    protected transient boolean dirtyArc = false;
    static /* synthetic */ Class class$jsynoptic$builtin$EllipseShape;

    public EllipseShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.ratio = (double)this._w / (double)this._h;
        this.allowResize = true;
        this.fixedRatio = false;
        this.ellipse = new Ellipse2D.Double(n, n2 - this._h, n3 - 1, n4 - 1);
    }

    protected Shape getDelegateShape() {
        return this.ellipse;
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        if (this.ellipse instanceof Ellipse2D.Double) {
            Ellipse2D.Double double_ = (Ellipse2D.Double)this.ellipse;
            double_.x += (double)n;
            double_.y += (double)n2;
            return;
        }
        if (this.ellipse instanceof Arc2D.Double) {
            Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
            double_.x += (double)n;
            double_.y += (double)n2;
            return;
        }
    }

    public void setAnchor(int n, int n2) {
        super.setAnchor(n, n2);
        if (this.ellipse instanceof Ellipse2D.Double) {
            Ellipse2D.Double double_ = (Ellipse2D.Double)this.ellipse;
            double_.x = n;
            double_.y = n2 - this._h;
            return;
        }
        if (this.ellipse instanceof Arc2D.Double) {
            Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
            double_.x = n;
            double_.y = n2 - this._h;
            return;
        }
    }

    public void resize(int n, int n2) {
        RectangularShape rectangularShape;
        super.resize(n, n2);
        if (this.ellipse instanceof Ellipse2D.Double) {
            rectangularShape = (Ellipse2D.Double)this.ellipse;
            rectangularShape.x = this._ox;
            rectangularShape.y = this._oy - this._h;
            rectangularShape.height = this._h - 1;
            rectangularShape.width = this._w - 1;
        }
        if (this.ellipse instanceof Arc2D.Double) {
            rectangularShape = (Arc2D.Double)this.ellipse;
            ((Arc2D.Double)rectangularShape).x = this._ox;
            ((Arc2D.Double)rectangularShape).y = this._oy - this._h;
            ((Arc2D.Double)rectangularShape).height = this._h - 1;
            ((Arc2D.Double)rectangularShape).width = this._w - 1;
        }
    }

    public Abstract1DShape.PropertiesPanel createPanel() {
        return new EllipsePropertiesPanel();
    }

    protected boolean updateArc() {
        double d;
        double d2;
        if (!(this.ellipse instanceof Arc2D.Double)) {
            return false;
        }
        Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
        if (this.startAngleSource != null) {
            try {
                d2 = this.startAngleSource.getDoubleValue(this.startAngleSourceIndex);
                if (this.startUnit == 1) {
                    d2 = Math.toDegrees(d2);
                }
            }
            catch (DataException dataException) {
                d2 = double_.start;
            }
        } else {
            d2 = double_.start;
        }
        if (this.endAngleSource != null) {
            try {
                d = this.endAngleSource.getDoubleValue(this.endAngleSourceIndex);
                if (this.endUnit == 1) {
                    d = Math.toDegrees(d);
                }
            }
            catch (DataException dataException) {
                d = double_.start + double_.extent;
            }
        } else {
            d = double_.start + double_.extent;
        }
        this.ellipse = new Arc2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1, d2, d - d2, double_.getArcType());
        return double_.start != d2 || d != double_.start + double_.extent;
    }

    public void notificationEnd(Object object) {
        if (this.dirtyArc) {
            this.dirty |= this.updateArc();
            this.dirtyArc = false;
        }
        super.notificationEnd(object);
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.startAngleSource) && this.startAngleSourceIndex >= l && this.startAngleSourceIndex <= l2) {
            this.dirtyArc = true;
        }
        if (dataSource.equals(this.endAngleSource) && this.endAngleSourceIndex >= l && this.endAngleSourceIndex <= l2) {
            this.dirtyArc = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.startAngleSource)) {
            this.startAngleSourceIndex = l2;
            this.dirtyArc = true;
        }
        if (dataSource.equals(this.endAngleSource)) {
            this.endAngleSourceIndex = l2;
            this.dirtyArc = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ellipse instanceof Ellipse2D.Double) {
            objectOutputStream.writeInt(0);
        } else if (this.ellipse instanceof Arc2D.Double) {
            Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
            objectOutputStream.writeInt(1);
            objectOutputStream.writeDouble(double_.start);
            objectOutputStream.writeDouble(double_.extent);
            objectOutputStream.writeInt(double_.getArcType());
        }
        DataSourcePool.global.writeDataSource(objectOutputStream, this.startAngleSource);
        DataSourcePool.global.writeDataSource(objectOutputStream, this.endAngleSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        switch (objectInputStream.readInt()) {
            case 0: {
                this.ellipse = new Ellipse2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1);
                break;
            }
            case 1: {
                double d = objectInputStream.readDouble();
                double d2 = objectInputStream.readDouble();
                int n = objectInputStream.readInt();
                this.ellipse = new Arc2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1, d, d2, n);
            }
        }
        this.startAngleSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.startAngleSource != null) {
            try {
                this.startAngleSource.addListener(this);
                this.startAngleSource.addEndNotificationListener(this);
                this.startAngleSourceIndex = this.startAngleSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.startAngleSourceIndex = 0L;
            }
        }
        this.endAngleSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.endAngleSource != null) {
            try {
                this.endAngleSource.addListener(this);
                this.endAngleSource.addEndNotificationListener(this);
                this.endAngleSourceIndex = this.endAngleSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.endAngleSourceIndex = 0L;
            }
        }
    }

    protected AbstractShape cloneShape() {
        EllipseShape ellipseShape = (EllipseShape)super.cloneShape();
        ellipseShape.ellipse = (Shape)((RectangularShape)this.ellipse).clone();
        return ellipseShape;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class EllipsePropertiesPanel
    extends Abstract2DShape.PropertiesPanel2D {
        protected ActionRadioButton rbfull;
        protected ActionRadioButton rbsourcestart;
        protected ActionRadioButton rbsourceend;
        protected JRadioButton rbpie;
        protected JRadioButton rbchord;
        protected JRadioButton rbopen;
        protected JRadioButton rbfixedstart;
        protected JRadioButton rbfixedend;
        protected JRadioButton rbdegstart;
        protected JRadioButton rbdegend;
        protected JRadioButton rbradstart;
        protected JRadioButton rbradend;
        protected NumberField nfstart;
        protected NumberField nfend;
        protected SourceTree dstreestart;
        protected SourceTree dstreeend;
        protected JLabel lunitstart;
        protected JLabel lunitend;

        public EllipsePropertiesPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createContent(), "Center");
        }

        public JComponent createContent() {
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getString("Type:")));
            box2.add(Box.createHorizontalGlue());
            this.rbfull = new ActionRadioButton(this, resources.getString("Full")){
                private final /* synthetic */ EllipsePropertiesPanel this$1;
                {
                    this.this$1 = ellipsePropertiesPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.isSelected()) {
                        this.this$1.rbsourcestart.setEnabled(false);
                        this.this$1.rbfixedstart.setEnabled(false);
                        this.this$1.dstreestart.setEnabled(false);
                        this.this$1.rbsourceend.setEnabled(false);
                        this.this$1.rbfixedend.setEnabled(false);
                        this.this$1.dstreeend.setEnabled(false);
                        this.this$1.nfstart.setEnabled(false);
                        this.this$1.nfend.setEnabled(false);
                        this.this$1.lunitstart.setEnabled(false);
                        this.this$1.lunitend.setEnabled(false);
                        this.this$1.rbdegstart.setEnabled(false);
                        this.this$1.rbdegend.setEnabled(false);
                        this.this$1.rbradstart.setEnabled(false);
                        this.this$1.rbradend.setEnabled(false);
                    } else {
                        this.this$1.rbfixedstart.setEnabled(true);
                        this.this$1.rbfixedend.setEnabled(true);
                        this.this$1.lunitstart.setEnabled(true);
                        this.this$1.lunitend.setEnabled(true);
                        this.this$1.rbdegstart.setEnabled(true);
                        this.this$1.rbdegend.setEnabled(true);
                        this.this$1.rbradstart.setEnabled(true);
                        this.this$1.rbradend.setEnabled(true);
                        this.this$1.rbsourcestart.setEnabled(true);
                        this.this$1.rbsourcestart.setSelected(EllipsePropertiesPanel.access$000((EllipsePropertiesPanel)this.this$1).startAngleSource != null);
                        this.this$1.rbfixedstart.setSelected(EllipsePropertiesPanel.access$000((EllipsePropertiesPanel)this.this$1).startAngleSource == null);
                        this.this$1.rbsourcestart.apply();
                        this.this$1.rbsourceend.setEnabled(true);
                        this.this$1.rbsourceend.setSelected(EllipsePropertiesPanel.access$000((EllipsePropertiesPanel)this.this$1).endAngleSource != null);
                        this.this$1.rbfixedend.setSelected(EllipsePropertiesPanel.access$000((EllipsePropertiesPanel)this.this$1).endAngleSource == null);
                        this.this$1.rbsourceend.apply();
                    }
                }
            };
            box2.add(this.rbfull);
            this.rbpie = new JRadioButton(resources.getString("Pie"));
            box2.add(this.rbpie);
            this.rbchord = new JRadioButton(resources.getString("Chord"));
            box2.add(this.rbchord);
            this.rbopen = new JRadioButton(resources.getString("Open"));
            box2.add(this.rbopen);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbfull);
            buttonGroup.add(this.rbpie);
            buttonGroup.add(this.rbchord);
            buttonGroup.add(this.rbopen);
            box.add(box2);
            box2 = Box.createHorizontalBox();
            Box box3 = Box.createVerticalBox();
            box3.setBorder(BorderFactory.createTitledBorder(resources.getString("StartAngle")));
            Box box4 = Box.createHorizontalBox();
            this.lunitstart = new JLabel(resources.getString("Unit:"));
            box4.add(this.lunitstart);
            box4.add(Box.createHorizontalGlue());
            this.rbdegstart = new JRadioButton(resources.getString("Degree"), EllipseShape.this.startUnit == 0);
            box4.add(this.rbdegstart);
            this.rbradstart = new JRadioButton(resources.getString("Radian"), EllipseShape.this.startUnit == 1);
            box4.add(this.rbradstart);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbdegstart);
            buttonGroup.add(this.rbradstart);
            box3.add(box4);
            box4 = Box.createHorizontalBox();
            this.rbfixedstart = new JRadioButton(resources.getString("FixedValue:"));
            box4.add(this.rbfixedstart);
            this.nfstart = new NumberField(0.0);
            box4.add(this.nfstart);
            box3.add(box4);
            box4 = Box.createHorizontalBox();
            this.rbsourcestart = new ActionRadioButton(this, resources.getString("UseDataSource")){
                private final /* synthetic */ EllipsePropertiesPanel this$1;
                {
                    this.this$1 = ellipsePropertiesPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.nfstart.setEnabled(!this.isSelected());
                    this.this$1.dstreestart.setEnabled(this.isSelected());
                }
            };
            box4.add(this.rbsourcestart);
            box4.add(Box.createHorizontalGlue());
            box3.add(box4);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbfixedstart);
            buttonGroup.add(this.rbsourcestart);
            this.dstreestart = new SourceTree(DataSourcePool.global);
            this.dstreestart.setVisibleRowCount(5);
            this.dstreestart.setSelectedValue(EllipseShape.this.startAngleSource);
            box3.add(new JScrollPane(this.dstreestart));
            box2.add(box3);
            box3 = Box.createVerticalBox();
            box3.setBorder(BorderFactory.createTitledBorder(resources.getString("EndAngle")));
            box4 = Box.createHorizontalBox();
            this.lunitend = new JLabel(resources.getString("Unit:"));
            box4.add(this.lunitend);
            box4.add(Box.createHorizontalGlue());
            this.rbdegend = new JRadioButton(resources.getString("Degree"), EllipseShape.this.endUnit == 0);
            box4.add(this.rbdegend);
            this.rbradend = new JRadioButton(resources.getString("Radian"), EllipseShape.this.endUnit == 1);
            box4.add(this.rbradend);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbdegend);
            buttonGroup.add(this.rbradend);
            box3.add(box4);
            box4 = Box.createHorizontalBox();
            this.rbfixedend = new JRadioButton(resources.getString("FixedValue:"));
            box4.add(this.rbfixedend);
            this.nfend = new NumberField(0.0);
            box4.add(this.nfend);
            box3.add(box4);
            box4 = Box.createHorizontalBox();
            this.rbsourceend = new ActionRadioButton(this, resources.getString("UseDataSource")){
                private final /* synthetic */ EllipsePropertiesPanel this$1;
                {
                    this.this$1 = ellipsePropertiesPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$1.nfend.setEnabled(!this.isSelected());
                    this.this$1.dstreeend.setEnabled(this.isSelected());
                }
            };
            box4.add(this.rbsourceend);
            box4.add(Box.createHorizontalGlue());
            box3.add(box4);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbfixedend);
            buttonGroup.add(this.rbsourceend);
            this.dstreeend = new SourceTree(DataSourcePool.global);
            this.dstreeend.setVisibleRowCount(5);
            this.dstreeend.setSelectedValue(EllipseShape.this.endAngleSource);
            box3.add(new JScrollPane(this.dstreeend));
            box2.add(box3);
            box.add(box2);
            if (EllipseShape.this.ellipse instanceof Ellipse2D.Double) {
                this.rbfull.setSelected(true);
            } else {
                Arc2D.Double double_ = (Arc2D.Double)EllipseShape.this.ellipse;
                this.rbfull.setSelected(false);
                switch (double_.getArcType()) {
                    case 1: {
                        this.rbchord.setSelected(true);
                        break;
                    }
                    case 0: {
                        this.rbopen.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.rbpie.setSelected(true);
                    }
                }
                double d = double_.start;
                double d2 = double_.start + double_.extent;
                if (EllipseShape.this.startUnit == 1) {
                    d = Math.toRadians(d);
                }
                if (EllipseShape.this.endUnit == 1) {
                    d2 = Math.toRadians(d2);
                }
                this.nfstart.setText(Double.toString(d));
                this.nfend.setText(Double.toString(d2));
            }
            this.rbsourcestart.apply();
            this.rbsourceend.apply();
            this.rbfull.apply();
            box.add(super.createContent());
            return box;
        }

        public void updateProperties() {
            Object object;
            super.updateProperties();
            if (this.rbfull.isSelected()) {
                EllipseShape.this.ellipse = new Ellipse2D.Double(EllipseShape.this._ox, EllipseShape.this._oy - EllipseShape.this._h, EllipseShape.this._w - 1, EllipseShape.this._h - 1);
                if (EllipseShape.this.startAngleSource != null) {
                    EllipseShape.this.startAngleSource.removeListener(EllipseShape.this);
                }
                EllipseShape.this.startAngleSource = null;
                if (EllipseShape.this.endAngleSource != null) {
                    EllipseShape.this.endAngleSource.removeListener(EllipseShape.this);
                }
                EllipseShape.this.endAngleSource = null;
                return;
            }
            EllipseShape.this.startUnit = this.rbdegstart.isSelected() ? 0 : 1;
            EllipseShape.this.endUnit = this.rbdegend.isSelected() ? 0 : 1;
            double d = this.nfstart.getDoubleValue();
            if (EllipseShape.this.startUnit == 1) {
                d = Math.toDegrees(d);
            }
            double d2 = this.nfend.getDoubleValue();
            if (EllipseShape.this.endUnit == 1) {
                d2 = Math.toDegrees(d2);
            }
            if (EllipseShape.this.startAngleSource != null) {
                EllipseShape.this.startAngleSource.removeListener(EllipseShape.this);
                EllipseShape.this.startAngleSource.removeEndNotificationListener(EllipseShape.this);
            }
            if (EllipseShape.this.endAngleSource != null) {
                EllipseShape.this.endAngleSource.removeListener(EllipseShape.this);
                EllipseShape.this.endAngleSource.removeEndNotificationListener(EllipseShape.this);
            }
            EllipseShape.this.startAngleSource = (object = this.dstreestart.getSelectedSourceOrCollection()) instanceof DataSource ? (DataSource)object : null;
            object = this.dstreeend.getSelectedSourceOrCollection();
            EllipseShape.this.endAngleSource = object instanceof DataSource ? (DataSource)object : null;
            if (EllipseShape.this.startAngleSource != null) {
                try {
                    EllipseShape.this.startAngleSourceIndex = EllipseShape.this.startAngleSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    EllipseShape.this.startAngleSourceIndex = 0L;
                }
                try {
                    d = EllipseShape.this.startAngleSource.getDoubleValue(EllipseShape.this.startAngleSourceIndex);
                    if (EllipseShape.this.startUnit == 1) {
                        d = Math.toDegrees(d);
                    }
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                EllipseShape.this.startAngleSource.addListener(EllipseShape.this);
                EllipseShape.this.startAngleSource.addEndNotificationListener(EllipseShape.this);
            }
            if (EllipseShape.this.endAngleSource != null) {
                try {
                    EllipseShape.this.endAngleSourceIndex = EllipseShape.this.endAngleSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    EllipseShape.this.endAngleSourceIndex = 0L;
                }
                try {
                    d2 = EllipseShape.this.endAngleSource.getDoubleValue(EllipseShape.this.endAngleSourceIndex);
                    if (EllipseShape.this.endUnit == 1) {
                        d2 = Math.toDegrees(d2);
                    }
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                EllipseShape.this.endAngleSource.addListener(EllipseShape.this);
                EllipseShape.this.endAngleSource.addEndNotificationListener(EllipseShape.this);
            }
            EllipseShape.this.ellipse = this.rbpie.isSelected() ? new Arc2D.Double(EllipseShape.this._ox, EllipseShape.this._oy - EllipseShape.this._h, EllipseShape.this._w - 1, EllipseShape.this._h - 1, d, d2 - d, 2) : (this.rbchord.isSelected() ? new Arc2D.Double(EllipseShape.this._ox, EllipseShape.this._oy - EllipseShape.this._h, EllipseShape.this._w - 1, EllipseShape.this._h - 1, d, d2 - d, 1) : new Arc2D.Double(EllipseShape.this._ox, EllipseShape.this._oy - EllipseShape.this._h, EllipseShape.this._w - 1, EllipseShape.this._h - 1, d, d2 - d, 0));
        }

        protected String fillColorLabel() {
            return resources.getString("FillEllipse");
        }

        static /* synthetic */ EllipseShape access$000(EllipsePropertiesPanel ellipsePropertiesPanel) {
            return ellipsePropertiesPanel.EllipseShape.this;
        }
    }
}

