/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.base.Linkable;
import jsynoptic.ui.LongAction;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.ui.ColorMapper;
import simtools.ui.DynamicColorChooser;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public abstract class Abstract1DShape
extends AbstractShape
implements Resizable,
DataSourceListener,
EndNotificationListener,
ContextualActionProvider,
Linkable {
    static final long serialVersionUID = 1292256994785217201L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$Abstract1DShape == null ? (class$jsynoptic$builtin$Abstract1DShape = Abstract1DShape.class$("jsynoptic.builtin.Abstract1DShape")) : class$jsynoptic$builtin$Abstract1DShape);
    public static int MIN_SIZE = 20;
    protected Color drawColor = Color.black;
    protected transient Color drawDynamicColor = null;
    protected ColorMapper drawMapper;
    protected transient DataSource drawMapperSource;
    protected transient long drawMapperIndex;
    protected boolean allowResize;
    protected boolean fixedRatio;
    protected double ratio;
    protected String link;
    protected transient boolean dirtyDrawColor = false;
    protected transient boolean dirty = false;
    protected transient Rectangle dirtyRectangle = null;
    static /* synthetic */ Class class$jsynoptic$builtin$Abstract1DShape;

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public Abstract1DShape(int n, int n2, int n3, int n4) {
        super(n, n2);
        this._w = n3;
        this._h = n4;
    }

    protected abstract Shape getDelegateShape();

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.getDelegateShape().getPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getDelegateShape().getPathIterator(affineTransform, d);
    }

    protected void drawHook(Graphics2D graphics2D, boolean bl) {
    }

    public void draw(Graphics2D graphics2D) {
        Color color;
        Color color2 = graphics2D.getColor();
        Color color3 = graphics2D.getBackground();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawHook(graphics2D, false);
        Color color4 = color = this.drawDynamicColor != null ? this.drawDynamicColor : this.drawColor;
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.draw(this.getDelegateShape());
        }
        this.drawHook(graphics2D, true);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setBackground(color3);
        graphics2D.setColor(color2);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("properties"));
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("properties"))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    PropertiesPanel propertiesPanel = Abstract1DShape.this.createPanel();
                    int n = JOptionPane.showConfirmDialog(null, propertiesPanel, resources.getString("propertiesTitle"), 2, -1);
                    if (n == 0) {
                        Rectangle rectangle = Abstract1DShape.this.getBounds();
                        propertiesPanel.updateProperties();
                        rectangle.add(Abstract1DShape.this.getBounds());
                        Abstract1DShape.this.notifyChange(rectangle);
                    }
                }
            }.start();
            return true;
        }
        return false;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    public PropertiesPanel createPanel() {
        return new PropertiesPanel();
    }

    public void notificationEnd(Object object) {
        if (this.dirtyDrawColor) {
            this.dirtyDrawColor = false;
            Color color = null;
            if (this.drawMapper != null) {
                color = (Color)this.drawMapper.getPaint(this.drawMapperSource, this.drawMapperIndex);
            }
            this.dirtyDrawColor = color == null ? this.drawDynamicColor != null : !color.equals(this.drawDynamicColor);
            this.drawDynamicColor = color;
            this.dirty |= this.dirtyDrawColor;
            this.dirtyDrawColor = false;
        }
        if (this.dirty) {
            this.notifyChange(this.dirtyRectangle);
            this.dirtyRectangle = null;
            this.dirty = false;
        }
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.drawMapperSource)) {
            this.drawMapperIndex = l2;
            this.dirtyDrawColor = true;
        }
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.drawMapperSource)) {
            if (this.drawMapperIndex < l || this.drawMapperIndex > l2) {
                return;
            }
            this.dirtyDrawColor = true;
        }
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void resize(int n, int n2) {
        if (!this.allowResize) {
            return;
        }
        if (!this.fixedRatio) {
            this._w += n;
            this._h += n2;
            if (this._w < MIN_SIZE) {
                this._w = MIN_SIZE;
            }
            if (this._h < MIN_SIZE) {
                this._h = MIN_SIZE;
            }
            return;
        }
        this._w += n;
        this._h += n2;
        double d = Math.max((double)this._w, (double)this._h * this.ratio);
        this._w = (int)d;
        this._h = (int)(d / this.ratio);
        if (this._w < MIN_SIZE) {
            this._w = MIN_SIZE;
        }
        if (this._h < MIN_SIZE) {
            this._h = MIN_SIZE;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.drawMapperSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.drawMapperSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.drawMapperSource != null) {
            try {
                this.drawMapperSource.addListener(this);
                this.drawMapperSource.addEndNotificationListener(this);
                this.drawMapperIndex = this.drawMapperSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.drawMapperIndex = 0L;
            }
        }
        this.drawDynamicColor = this.drawMapper != null ? (Color)this.drawMapper.getPaint(this.drawMapperSource, this.drawMapperIndex) : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PropertiesPanel
    extends JPanel {
        protected JButton bdrawcolor;
        protected Color noColor;
        protected JCheckBox cbResize;
        protected JCheckBox cbRatio;
        protected JCheckBox cbdraw;
        protected JLabel lwidth;
        protected JLabel lheight;
        protected NumberField nfWidth;
        protected NumberField nfHeight;
        protected Color drawColor;
        protected ColorMapper drawMapper;
        protected transient DataSource drawMapperSource;

        public JComponent createContent() {
            return this.createContent(true);
        }

        public JComponent createContent(boolean bl) {
            return this.createContent(true, false);
        }

        public JComponent createContent(boolean bl, boolean bl2) {
            this.drawColor = Abstract1DShape.this.drawColor;
            this.drawMapper = Abstract1DShape.this.drawMapper;
            this.drawMapperSource = Abstract1DShape.this.drawMapperSource;
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            if (bl2) {
                this.cbdraw = new JCheckBox(this.lineColorLabel(), this.drawColor != null || this.drawMapper != null && this.drawMapperSource != null);
                box2.add(this.cbdraw);
            } else {
                this.cbdraw = null;
                box2.add(new JLabel(this.lineColorLabel()));
            }
            box2.add(Box.createHorizontalGlue());
            this.bdrawcolor = new JButton("    ");
            box2.add(this.bdrawcolor);
            this.noColor = this.bdrawcolor.getBackground();
            this.bdrawcolor.setFocusPainted(false);
            if (this.drawColor == null) {
                this.drawColor = Color.BLACK;
            }
            this.bdrawcolor.setBackground(this.drawColor);
            box.add(box2);
            box2 = Box.createHorizontalBox();
            this.cbResize = new JCheckBox(resources.getString("AllowResize"), Abstract1DShape.this.allowResize);
            box2.add(this.cbResize);
            box2.add(Box.createHorizontalGlue());
            this.cbRatio = new JCheckBox(resources.getString("FixedRatio"), Abstract1DShape.this.fixedRatio);
            box2.add(this.cbRatio);
            if (bl) {
                box.add(box2);
            }
            box2 = Box.createHorizontalBox();
            this.lwidth = new JLabel(resources.getString("Width"));
            box2.add(this.lwidth);
            this.nfWidth = new NumberField((long)Abstract1DShape.this._w);
            box2.add(this.nfWidth);
            this.nfWidth.setHorizontalAlignment(4);
            this.lheight = new JLabel(resources.getString("Height"));
            box2.add(this.lheight);
            this.nfHeight = new NumberField((long)Abstract1DShape.this._h);
            box2.add(this.nfHeight);
            this.nfHeight.setHorizontalAlignment(4);
            if (bl) {
                box.add(box2);
            }
            this.bdrawcolor.addActionListener(new ActionListener(this){
                private final /* synthetic */ PropertiesPanel this$1;
                {
                    this.this$1 = propertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = DynamicColorChooser.showDialog(null, this.this$1.lineColorChooserTitle(), null, this.this$1.drawColor, this.this$1.drawMapperSource, this.this$1.drawMapper);
                    if (color == null) {
                        return;
                    }
                    this.this$1.drawColor = color;
                    this.this$1.drawMapperSource = DynamicColorChooser.getSource();
                    this.this$1.drawMapper = DynamicColorChooser.getMapper();
                    this.this$1.bdrawcolor.setBackground(this.this$1.drawColor);
                    if (this.this$1.cbdraw != null) {
                        this.this$1.cbdraw.setSelected(true);
                    }
                }
            });
            return box;
        }

        public void updateProperties() {
            if (this.cbdraw != null && !this.cbdraw.isSelected()) {
                this.drawColor = null;
                this.drawMapper = null;
                this.drawMapperSource = null;
            }
            Abstract1DShape.this.drawColor = this.drawColor;
            Abstract1DShape.this.drawMapper = this.drawMapper;
            if (Abstract1DShape.this.drawMapperSource != null) {
                Abstract1DShape.this.drawMapperSource.removeListener(Abstract1DShape.this);
                Abstract1DShape.this.drawMapperSource.removeEndNotificationListener(Abstract1DShape.this);
            }
            Abstract1DShape.this.drawMapperSource = this.drawMapperSource;
            if (Abstract1DShape.this.drawMapperSource != null) {
                try {
                    Abstract1DShape.this.drawMapperIndex = Abstract1DShape.this.drawMapperSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    Abstract1DShape.this.drawMapperIndex = 0L;
                }
                Abstract1DShape.this.drawMapperSource.addListener(Abstract1DShape.this);
                Abstract1DShape.this.drawMapperSource.addEndNotificationListener(Abstract1DShape.this);
            }
            Abstract1DShape.this.allowResize = this.cbResize.isSelected();
            Abstract1DShape.this.fixedRatio = this.cbRatio.isSelected();
            Abstract1DShape.this._w = (int)this.nfWidth.getLongValue();
            Abstract1DShape.this._h = (int)this.nfHeight.getLongValue();
            Abstract1DShape.this.ratio = (double)Abstract1DShape.this._w / (double)Abstract1DShape.this._h;
        }

        protected String lineColorLabel() {
            return resources.getString("LineColor");
        }

        protected String lineColorChooserTitle() {
            return resources.getString("ChooseLineColor");
        }
    }
}

