/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import jsynoptic.plugins.jfreechart.JSynopticXYItemRenderer;
import org.jfree.chart.LegendItem;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.ui.ColorMapper;
import simtools.ui.MenuResourceBundle;
import simtools.ui.ResourceFinder;

public class JSynopticXYItemRendererHelper
implements Serializable {
    static final long serialVersionUID = 3439594416374185740L;
    public static MenuResourceBundle resources = ResourceFinder.getMenu((Class)(class$jsynoptic$plugins$jfreechart$JSynopticXYItemRendererHelper == null ? (class$jsynoptic$plugins$jfreechart$JSynopticXYItemRendererHelper = JSynopticXYItemRendererHelper.class$("jsynoptic.plugins.jfreechart.JSynopticXYItemRendererHelper")) : class$jsynoptic$plugins$jfreechart$JSynopticXYItemRendererHelper));
    protected int x_ary;
    protected transient DrawingSupplier supplier;
    protected Vector colorMappers;
    protected transient Vector sources;
    static /* synthetic */ Class class$jsynoptic$plugins$jfreechart$JSynopticXYItemRendererHelper;

    public JSynopticXYItemRendererHelper() {
        this(1);
    }

    public JSynopticXYItemRendererHelper(int n) {
        this.x_ary = n;
        this.colorMappers = new Vector();
        this.sources = new Vector();
    }

    public ColorMapper getColorMapper(int n) {
        if (n >= this.colorMappers.size()) {
            return null;
        }
        return (ColorMapper)this.colorMappers.get(n);
    }

    public void setColorMapper(int n, ColorMapper colorMapper) {
        if (n >= this.colorMappers.size()) {
            int n2;
            for (int i = n2 = this.colorMappers.size(); i < n; ++i) {
                this.colorMappers.add(null);
            }
            this.colorMappers.add(colorMapper);
        } else {
            this.colorMappers.set(n, colorMapper);
        }
    }

    public DataSource getDataSource(int n) {
        if (n >= this.sources.size()) {
            return null;
        }
        return (DataSource)this.sources.get(n);
    }

    public void setDataSource(int n, DataSource dataSource) {
        if (n >= this.sources.size()) {
            int n2;
            for (int i = n2 = this.sources.size(); i < n; ++i) {
                this.sources.add(null);
            }
            this.sources.add(dataSource);
        } else {
            this.sources.set(n, dataSource);
        }
    }

    public ColorMapper removeColorMapper(int n) {
        if (n >= this.colorMappers.size()) {
            return null;
        }
        return (ColorMapper)this.colorMappers.remove(n);
    }

    public DataSource removeDataSource(int n) {
        if (n >= this.sources.size()) {
            return null;
        }
        return (DataSource)this.sources.remove(n);
    }

    public DrawingSupplier getDrawingSupplier() {
        if (this.supplier == null) {
            this.supplier = new DefaultDrawingSupplier(){

                public Paint getNextPaint() {
                    Paint paint = super.getNextPaint();
                    if (JSynopticXYItemRendererHelper.this.x_ary > 1 && paint instanceof Color) {
                        Color color = (Color)paint;
                        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
                        fArray[0] = (float)((double)fArray[0] + 0.1 * (double)(JSynopticXYItemRendererHelper.this.x_ary - 1));
                        if (fArray[0] > 1.0f) {
                            fArray[0] = fArray[0] - 1.0f;
                        }
                        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
                    }
                    return paint;
                }
            };
        }
        return this.supplier;
    }

    public LegendItem getLegendItem(JSynopticXYItemRenderer jSynopticXYItemRenderer, int n, int n2) {
        LegendItem legendItem = jSynopticXYItemRenderer.getDefaultLegendItem(n, n2);
        if (this.x_ary > 1) {
            legendItem = new XAryLegendItem(legendItem);
        }
        return legendItem;
    }

    public Paint getItemPaint(JSynopticXYItemRenderer jSynopticXYItemRenderer, int n, int n2) {
        ColorMapper colorMapper = this.getColorMapper(n);
        if (colorMapper != null) {
            Paint paint;
            DataSource dataSource = this.getDataSource(n);
            try {
                paint = colorMapper.getPaint(dataSource, dataSource.getStartIndex() + (long)n2);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                paint = null;
            }
            if (paint != null) {
                return paint;
            }
        }
        return jSynopticXYItemRenderer.getDefaultItemPaint(n, n2);
    }

    public Paint getSeriesPaint(JSynopticXYItemRenderer jSynopticXYItemRenderer, int n) {
        Paint paint = jSynopticXYItemRenderer.getDefaultSeriesPaint(n);
        if (paint instanceof Color) {
            return paint;
        }
        return Color.black;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.sources.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            DataSourcePool.global.writeDataSource(objectOutputStream, (DataSource)this.sources.get(i));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.sources = new Vector();
        for (int i = 0; i < n; ++i) {
            this.sources.add(DataSourcePool.global.readDataSource(objectInputStream));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class XAryLegendItem
    extends LegendItem {
        public XAryLegendItem(LegendItem legendItem) {
            super(legendItem.getLabel() + " (" + (JSynopticXYItemRendererHelper.this.x_ary <= resources.getIntValue("legendXAryNum") ? resources.getString("legendXAryText" + JSynopticXYItemRendererHelper.this.x_ary) : resources.getString("legendXAryTextMore") + JSynopticXYItemRendererHelper.this.x_ary) + ")", "", legendItem.getShape(), legendItem.getPaint(), legendItem.getPaint(), null);
        }
    }
}

