/*
 * Decompiled with CFR 0.152.
 */
package sip4me.nist.javax.microedition.sip;

import java.io.IOException;
import java.io.OutputStream;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.microedition.sip.RefreshManager;
import sip4me.gov.nist.microedition.sip.RefreshTask;
import sip4me.gov.nist.microedition.sip.SipClientConnectionImpl;
import sip4me.gov.nist.microedition.sip.SipDialogImpl;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.ContactHeader;
import sip4me.gov.nist.siplite.header.ContentLengthHeader;
import sip4me.gov.nist.siplite.header.ExpiresHeader;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.nist.javax.microedition.sip.SipClientConnection;
import sip4me.nist.javax.microedition.sip.SipDialog;
import sip4me.nist.javax.microedition.sip.SipException;

public class SipRefreshHelper {
    private static SipRefreshHelper instance = null;
    private static RefreshManager refreshManager = null;

    public static SipRefreshHelper getInstance() {
        if (instance == null) {
            instance = new SipRefreshHelper();
            refreshManager = RefreshManager.getInstance();
        }
        return instance;
    }

    public void stop(int refreshID) {
        String taskId;
        try {
            taskId = String.valueOf(refreshID);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        RefreshTask refreshTask = refreshManager.getTask(taskId);
        if (refreshTask == null) {
            return;
        }
        refreshTask.cancel();
        refreshTask.getSipRefreshListener().refreshEvent(refreshID, 0, "refresh stopped for method " + refreshTask.getRequest().getMethod());
        SipDialog dialog = refreshTask.getSipClientConnection().getDialog();
        if (refreshTask.getRequest().getMethod() != "SUBSCRIBE" || dialog.getState() != 1 && dialog.getState() != 3) {
            this.update(refreshID, null, null, 0, 0);
        } else if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Not sending UNSUBSCRIBE because the dialog is terminated or not established");
        }
        refreshManager.removeTask(taskId);
    }

    public OutputStream update(int refreshID, String[] contact, String type, int length, int expires) throws IllegalArgumentException {
        String taskId;
        try {
            taskId = String.valueOf(refreshID);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        RefreshTask refreshTask = refreshManager.getTask(taskId);
        if (refreshTask == null) {
            return null;
        }
        SipClientConnection sipClientConnection = refreshTask.getSipClientConnection();
        Request requestNotCloned = refreshTask.getRequest();
        Request request = null;
        if (requestNotCloned.getMethod().equals("REGISTER")) {
            request = (Request)requestNotCloned.clone();
        } else if (requestNotCloned.getMethod().equals("SUBSCRIBE")) {
            try {
                request = ((SipDialogImpl)refreshTask.getSipClientConnection().getDialog()).getDialog().createRequest("SUBSCRIBE");
            }
            catch (sip4me.gov.nist.siplite.SipException e) {
                request = (Request)requestNotCloned.clone();
            }
        }
        if (request.getHeader("Authorization") != null) {
            request.removeHeader("Authorization");
            request = ((SipClientConnectionImpl)sipClientConnection).authenticateRequest(request);
        }
        if (request.getCSeqHeaderNumber() == requestNotCloned.getCSeqHeaderNumber()) {
            CSeqHeader cseq = request.getCSeqHeader();
            cseq.setSequenceNumber(cseq.getSequenceNumber() + 1);
            request.setCSeqHeader(cseq);
        }
        requestNotCloned = null;
        if (contact != null) {
            if (contact.length > 1 && request.getMethod().equals("SUBSCRIBE")) {
                request.removeHeader("Contact");
            }
            int i = 0;
            while (i < contact.length) {
                String contactURI = contact[i];
                Address address = null;
                try {
                    address = StackConnector.addressFactory.createAddress(contactURI);
                }
                catch (ParseException pe) {
                    throw new IllegalArgumentException("one of the contact addresses is not valid");
                }
                ContactHeader contactHeader = StackConnector.headerFactory.createContactHeader(address);
                request.addHeader(contactHeader);
                ++i;
            }
        }
        if (expires == -1) {
            request.removeHeader("Expires");
        } else if (expires >= 0) {
            ((ExpiresHeader)request.getHeader("Expires")).setExpires(expires);
        } else {
            throw new IllegalArgumentException("the expires value is not correct");
        }
        ContentLengthHeader contentLengthHeader = request.getContentLengthHeader();
        if (contentLengthHeader == null) {
            request.addHeader(StackConnector.headerFactory.createContentLengthHeader(0));
        }
        if (length > 0) {
            request.getContentLengthHeader().setContentLength(length);
        }
        refreshTask.updateRequest(request);
        if (type == null) {
            try {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Before sending, request line is: " + request.getRequestLine().encode());
                }
                sipClientConnection.send();
            }
            catch (SipException sipex) {
                sipex.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return null;
        }
        OutputStream contentOutputStream = null;
        try {
            contentOutputStream = sipClientConnection.openContentOutputStream();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        try {
            contentOutputStream.write(type.getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return contentOutputStream;
    }
}

