/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import java.util.Enumeration;
import java.util.Vector;
import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.siplite.header.Header;

public class HeaderList
extends Header {
    protected Vector sipHeaderVector = new Vector();

    public Object clone() {
        try {
            HeaderList retval = (HeaderList)this.getClass().newInstance();
            if (this.headerName != null) {
                retval.headerName = new String(this.headerName);
            }
            if (this.headerValue != null) {
                retval.headerValue = new String(this.headerValue);
            }
            retval.sipHeaderVector = new Vector();
            int i = 0;
            while (i < this.sipHeaderVector.size()) {
                Header siphdr = (Header)this.sipHeaderVector.elementAt(i);
                Header newHdr = (Header)siphdr.clone();
                retval.sipHeaderVector.addElement(newHdr);
                ++i;
            }
            return retval;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.print("Problem with clone method");
            System.exit(0);
            return null;
        }
    }

    public HeaderList() {
    }

    public void concatenate(HeaderList other, boolean top) {
        block4: {
            if (other == null) break block4;
            if (top) {
                int i = 0;
                while (i < this.size()) {
                    Header sipHeader = (Header)this.elementAt(i);
                    other.add(sipHeader);
                    this.sipHeaderVector = other.sipHeaderVector;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < other.size()) {
                    Header sipHeader = (Header)other.elementAt(i);
                    this.add(sipHeader);
                    ++i;
                }
            }
        }
    }

    public HeaderList(String sipHeaderName) {
        this.headerName = sipHeaderName;
    }

    public void add(Object sipHeader) throws IllegalArgumentException {
        if (!this.headerName.equals(((Header)sipHeader).getHeaderName())) {
            throw new IllegalArgumentException("bad type");
        }
        this.sipHeaderVector.addElement(sipHeader);
    }

    public void addFirst(Object sipHeader) {
        if (sipHeader != null) {
            Vector<Object> vec = new Vector<Object>();
            vec.addElement(sipHeader);
            int i = 0;
            while (i < this.sipHeaderVector.size()) {
                vec.addElement(this.sipHeaderVector.elementAt(i));
                ++i;
            }
            this.sipHeaderVector = vec;
        }
    }

    public boolean isEmpty() {
        return this.sipHeaderVector.isEmpty();
    }

    public int size() {
        return this.sipHeaderVector.size();
    }

    public Object elementAt(int i) {
        return this.sipHeaderVector.elementAt(i);
    }

    public void removeElement(Object element) {
        this.sipHeaderVector.removeElement(element);
    }

    public void removeFirst() {
        if (this.sipHeaderVector.size() == 0) {
            return;
        }
        this.sipHeaderVector.removeElementAt(0);
    }

    public void removeLast() {
        if (this.sipHeaderVector.size() != 0) {
            this.sipHeaderVector.removeElementAt(this.sipHeaderVector.size() - 1);
        }
    }

    public Vector getHeadersAsEncodedStrings() {
        Vector<String> retval = new Vector<String>();
        int i = 0;
        while (i < this.size()) {
            Header sipheader = (Header)this.elementAt(i);
            retval.addElement(sipheader.encode());
            ++i;
        }
        return retval;
    }

    public Enumeration getElements() {
        return this.sipHeaderVector.elements();
    }

    public Header getFirst() {
        if (this.sipHeaderVector.size() == 0) {
            return null;
        }
        return (Header)this.sipHeaderVector.elementAt(0);
    }

    public Object first() {
        if (this.sipHeaderVector.size() == 0) {
            return null;
        }
        return this.sipHeaderVector.elementAt(0);
    }

    public Object last() {
        if (this.sipHeaderVector.size() == 0) {
            return null;
        }
        return (Header)this.sipHeaderVector.elementAt(this.sipHeaderVector.size() - 1);
    }

    public Object getValue() {
        Vector<Header> retval = new Vector<Header>();
        int i = 0;
        while (i < this.size()) {
            Header sipheader = (Header)this.elementAt(i);
            retval.addElement(sipheader);
            ++i;
        }
        return retval;
    }

    public NameValueList getParameters() {
        return null;
    }

    public String encode() {
        if (this.sipHeaderVector.isEmpty()) {
            return "";
        }
        StringBuffer encoding = new StringBuffer();
        if (this.headerName.equals("WWW-Authenticate") || this.headerName.equals("Proxy-Authenticate") || this.headerName.equals("Authorization") || this.headerName.equals("Proxy-Authorization")) {
            int i = 0;
            while (i < this.sipHeaderVector.size()) {
                Header sipheader = (Header)this.sipHeaderVector.elementAt(i);
                encoding.append(sipheader.encode());
                ++i;
            }
            return encoding.toString();
        }
        return String.valueOf(this.headerName) + ":" + " " + this.encodeBody() + "\r\n";
    }

    protected String encodeBody() {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < this.sipHeaderVector.size()) {
            Header sipHeader = (Header)this.sipHeaderVector.elementAt(i);
            sbuf.append(sipHeader.encodeBody());
            if (i + 1 < this.sipHeaderVector.size()) {
                sbuf.append(",");
            }
            ++i;
        }
        return sbuf.toString();
    }

    public Vector getHeaders() {
        return this.sipHeaderVector;
    }
}

