/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite;

import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.siplite.AuthenticationHelper;
import sip4me.gov.nist.siplite.ListeningPoint;
import sip4me.gov.nist.siplite.RequestEvent;
import sip4me.gov.nist.siplite.ResponseEvent;
import sip4me.gov.nist.siplite.SipListener;
import sip4me.gov.nist.siplite.SipProvider;
import sip4me.gov.nist.siplite.SipStack;
import sip4me.gov.nist.siplite.TimeoutEvent;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.HeaderFactory;
import sip4me.gov.nist.siplite.header.MaxForwardsHeader;
import sip4me.gov.nist.siplite.message.MessageFactory;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.ClientTransaction;

public class RegistrationHelper
implements SipListener,
Runnable {
    private SipStack sipStack;
    private SipProvider sipProvider;
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private String userName;
    private String userAddress;
    private ListeningPoint lp;
    private Thread myThread;
    protected boolean successfulRegistration;
    private AuthenticationHelper authenticationHelper;

    public RegistrationHelper(SipStack myStack, String userName, String userAddress, ListeningPoint lp) {
        this.sipStack = myStack;
        this.userName = userName;
        this.userAddress = userAddress;
        this.messageFactory = new MessageFactory();
        this.headerFactory = new HeaderFactory();
        this.lp = lp;
        this.myThread = new Thread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRegister() {
        this.myThread.start();
        RegistrationHelper registrationHelper = this;
        synchronized (registrationHelper) {
            try {
                System.out.println("WAIT");
                this.wait();
                System.out.println("WAKE UP");
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("starting registration thread");
            }
            this.sipStack.stackInitialized = false;
            Hop hop = this.sipStack.getRouter().getOutboundProxy();
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("got listening point");
            }
            this.sipProvider = this.lp.getProvider();
            StringBuffer requestLine = new StringBuffer("REGISTER sip:").append(this.sipStack.getNextHop().getHost()).append(":").append(this.sipStack.getNextHop().getPort()).append(";transport=" + hop.getTransport()).append(" SIP/2.0\r\n");
            StringBuffer from = new StringBuffer("From: <sip:").append(this.userName).append("@").append(this.userAddress).append(">;tag=1234\r\n");
            StringBuffer to = new StringBuffer("To: <sip:").append(this.userName).append("@").append(this.userAddress).append(">\r\n");
            String via = this.lp.messageProcessor.getViaHeader().toString();
            int port = this.lp.getPort();
            StringBuffer contact = new StringBuffer("Contact: <sip:" + this.userName + "@" + this.sipStack.getIPAddress() + ":" + port + ";transport=" + hop.getTransport() + ">\r\n");
            CallIdHeader callId = this.sipProvider.getNewCallId();
            CSeqHeader cseq = new CSeqHeader();
            cseq.setMethod("REGISTER");
            cseq.setSequenceNumber(1);
            MaxForwardsHeader maxForwards = new MaxForwardsHeader();
            maxForwards.setMaxForwards(1);
            String registerRequest = requestLine + via + callId.toString() + cseq.toString() + maxForwards.toString() + from + to + contact;
            System.out.println(registerRequest);
            Request request = this.messageFactory.createRequest(registerRequest);
            ClientTransaction ct = this.sipProvider.getNewClientTransaction(request);
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("Got client Transaction " + ct);
            }
            System.out.println("SENDING REGISTER TO THE PROXY");
            ct.sendRequest();
        }
        catch (Exception ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logException(ex);
            }
            RegistrationHelper registrationHelper = this;
            synchronized (registrationHelper) {
                System.out.println("NOTIFY");
                this.notify();
            }
        }
    }

    public void processRequest(RequestEvent requestEvent) {
        System.out.println("Ignoring request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(ResponseEvent responseEvent) {
        block12: {
            Response response = responseEvent.getResponse();
            if (response.getStatusCode() == 200) {
                this.successfulRegistration = true;
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Registration listener : sending notify!");
                }
                RegistrationHelper registrationHelper = this;
                synchronized (registrationHelper) {
                    System.out.println("NOTIFY");
                    this.notify();
                }
            }
            if (response.getStatusCode() == 407 || response.getStatusCode() == 401) {
                try {
                    ClientTransaction clientTransac = responseEvent.getClientTransaction();
                    Request newRequest = this.authenticationHelper.createNewRequest(this.sipStack, clientTransac.getRequest(), response);
                    if (newRequest == null) {
                        if (LogWriter.needsLogging) {
                            LogWriter.logMessage("Authentication failed...");
                        }
                        return;
                    }
                    ClientTransaction ct = this.sipProvider.getNewClientTransaction(newRequest);
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Got client Transaction " + ct);
                    }
                    ct.sendRequest();
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("RegistrationHelper: request sent:\n" + newRequest);
                    }
                }
                catch (Exception ex) {
                    if (!LogWriter.needsLogging) break block12;
                    LogWriter.logMessage("RegistrationHelper: processResponse(), exception raised: " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimeout(TimeoutEvent timeoutEvent) {
        RegistrationHelper registrationHelper = this;
        synchronized (registrationHelper) {
            System.out.println("NOTIFY");
            this.notify();
        }
    }
}

