/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.sip;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import sip4me.gov.nist.microedition.sip.ConnectionBaseInterface;

public class SipConnector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static String platform;
    private static boolean j2me;
    private static String classRoot;

    static {
        j2me = true;
        if (System.getProperty("microedition.configuration") != null) {
            j2me = true;
        }
        platform = System.getProperty("microedition.platform");
        classRoot = "sip4me.gov.nist.microedition.io";
    }

    private SipConnector() {
    }

    public static Connection open(String name) throws IOException {
        return SipConnector.open(name, 3);
    }

    public static Connection open(String name, int mode) throws IOException {
        return SipConnector.open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        platform = "j2me";
        if (platform != null) {
            try {
                return SipConnector.openPrim(name, mode, timeouts, platform);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return SipConnector.openPrim(name, mode, timeouts, j2me ? "j2me" : "j2se");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConnectionNotFoundException("The requested protocol does not exist " + name);
        }
    }

    private static Connection openPrim(String name, int mode, boolean timeouts, String platform) throws IOException, ClassNotFoundException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Null URL");
        }
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IllegalArgumentException("no ':' in URL");
        }
        try {
            String protocol = name.substring(0, colon);
            name = name.substring(colon + 1);
            protocol = protocol.replace('-', '_');
            Class<?> clazz = Class.forName(String.valueOf(classRoot) + "." + platform + "." + protocol + ".Protocol");
            ConnectionBaseInterface uc = (ConnectionBaseInterface)clazz.newInstance();
            return uc.openPrim(name, mode, timeouts);
        }
        catch (InstantiationException x) {
            throw new IOException(x.toString());
        }
        catch (IllegalAccessException x) {
            throw new IOException(x.toString());
        }
        catch (ClassCastException x) {
            throw new IOException(x.toString());
        }
    }

    public static DataInputStream openDataInputStream(String name) throws IOException {
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IOException("This method is not authorized for this protocol");
        }
        String protocol = name.substring(0, colon);
        if (protocol.equals("sip")) {
            throw new IOException("This method is not authorized for this protocol");
        }
        InputConnection con = (InputConnection)SipConnector.open(name, 1);
        try {
            DataInputStream dataInputStream = con.openDataInputStream();
            return dataInputStream;
        }
        finally {
            con.close();
        }
    }

    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IOException("This method is not authorized for this protocol");
        }
        String protocol = name.substring(0, colon);
        if (protocol.equals("sip")) {
            throw new IOException("This method is not authorized for this protocol");
        }
        OutputConnection con = (OutputConnection)SipConnector.open(name, 2);
        try {
            DataOutputStream dataOutputStream = con.openDataOutputStream();
            return dataOutputStream;
        }
        finally {
            con.close();
        }
    }

    public static InputStream openInputStream(String name) throws IOException {
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IOException("This method is not authorized for this protocol");
        }
        String protocol = name.substring(0, colon);
        if (protocol.equals("sip")) {
            throw new IOException("This method is not authorized for this protocol");
        }
        return SipConnector.openDataInputStream(name);
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        int colon = name.indexOf(58);
        if (colon < 1) {
            throw new IOException("This method is not authorized for this protocol");
        }
        String protocol = name.substring(0, colon);
        if (protocol.equals("sip")) {
            throw new IOException("This method is not authorized for this protocol");
        }
        return SipConnector.openDataOutputStream(name);
    }
}

