/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp;

import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.javax.sdp.MediaDescription;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.SessionDescription;
import sip4me.gov.nist.javax.sdp.TimeDescription;
import sip4me.gov.nist.javax.sdp.fields.AttributeField;
import sip4me.gov.nist.javax.sdp.fields.BandwidthField;
import sip4me.gov.nist.javax.sdp.fields.ConnectionField;
import sip4me.gov.nist.javax.sdp.fields.EmailField;
import sip4me.gov.nist.javax.sdp.fields.InformationField;
import sip4me.gov.nist.javax.sdp.fields.KeyField;
import sip4me.gov.nist.javax.sdp.fields.MediaField;
import sip4me.gov.nist.javax.sdp.fields.OriginField;
import sip4me.gov.nist.javax.sdp.fields.PhoneField;
import sip4me.gov.nist.javax.sdp.fields.ProtoVersionField;
import sip4me.gov.nist.javax.sdp.fields.RepeatField;
import sip4me.gov.nist.javax.sdp.fields.SessionNameField;
import sip4me.gov.nist.javax.sdp.fields.TimeField;
import sip4me.gov.nist.javax.sdp.fields.URIField;
import sip4me.gov.nist.javax.sdp.fields.ZoneField;
import sip4me.gov.nist.javax.sdp.parser.SDPAnnounceParser;
import sip4me.gov.nist.microedition.sip.StackConnector;

public class SdpFactory {
    private SdpFactory() {
    }

    public static SdpFactory getInstance() throws SdpException {
        return new SdpFactory();
    }

    public SessionDescription createSessionDescription() throws SdpException {
        SessionDescription sessionDescription = new SessionDescription();
        ProtoVersionField ProtoVersionField2 = new ProtoVersionField();
        ProtoVersionField2.setVersion(0);
        sessionDescription.setVersion(ProtoVersionField2);
        OriginField originImpl = null;
        try {
            originImpl = this.createOrigin("-", StackConnector.getInstance().getLocalAddress());
        }
        catch (IOException e) {
            throw new SdpException("Problem getting Stack address. This shouldn't happen!");
        }
        sessionDescription.setOrigin(originImpl);
        SessionNameField sessionNameImpl = new SessionNameField();
        sessionNameImpl.setValue("-");
        sessionDescription.setSessionName(sessionNameImpl);
        TimeDescription timeDescription = new TimeDescription();
        TimeField timeImpl = new TimeField();
        timeImpl.setZero();
        timeDescription.setTime(timeImpl);
        Vector<TimeDescription> times = new Vector<TimeDescription>();
        times.addElement(timeDescription);
        sessionDescription.setTimeDescriptions(times);
        return sessionDescription;
    }

    public SessionDescription createSessionDescription(String desc) throws SdpParseException {
        try {
            SDPAnnounceParser sdpParser = new SDPAnnounceParser(desc);
            return sdpParser.parse();
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new SdpParseException(0, 0, "Could not parse message");
        }
    }

    public BandwidthField createBandwidth(String modifier, int value) {
        BandwidthField bandWidthImpl = new BandwidthField();
        try {
            bandWidthImpl.setType(modifier);
            bandWidthImpl.setValue(value);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return bandWidthImpl;
    }

    public AttributeField createAttribute(String name, String value) {
        AttributeField attributeImpl = new AttributeField();
        try {
            attributeImpl.setName(name);
            attributeImpl.setValue(value);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return attributeImpl;
    }

    public InformationField createInfo(String value) {
        InformationField infoImpl = new InformationField();
        try {
            infoImpl.setValue(value);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return infoImpl;
    }

    public PhoneField createPhone(String value) {
        PhoneField phoneImpl = new PhoneField();
        try {
            phoneImpl.setValue(value);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return phoneImpl;
    }

    public EmailField createEmail(String value) {
        EmailField emailImpl = new EmailField();
        try {
            emailImpl.setValue(value);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return emailImpl;
    }

    public URIField createURI(String value) throws SdpException {
        URIField uriImpl = new URIField();
        uriImpl.setURI(value);
        return uriImpl;
    }

    public SessionNameField createSessionName(String name) {
        SessionNameField sessionNameImpl = new SessionNameField();
        try {
            sessionNameImpl.setValue(name);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return sessionNameImpl;
    }

    public KeyField createKey(String method, String key) {
        KeyField keyImpl = new KeyField();
        try {
            keyImpl.setMethod(method);
            keyImpl.setKey(key);
        }
        catch (SdpException s) {
            s.printStackTrace();
            return null;
        }
        return keyImpl;
    }

    public ProtoVersionField createVersion(int value) {
        ProtoVersionField protoVersionField = new ProtoVersionField();
        try {
            protoVersionField.setVersion(value);
        }
        catch (SdpException s) {
            s.printStackTrace();
            return null;
        }
        return protoVersionField;
    }

    public MediaField createMedia(String media, int port, int numPorts, String transport, Vector staticRtpAvpTypes) throws SdpException {
        MediaField mediaImpl = new MediaField();
        mediaImpl.setMediaType(media);
        mediaImpl.setMediaPort(port);
        mediaImpl.setPortCount(numPorts);
        mediaImpl.setProtocol(transport);
        mediaImpl.setMediaFormats(staticRtpAvpTypes);
        return mediaImpl;
    }

    public OriginField createOrigin(String userName, String address) throws SdpException {
        OriginField originImpl = new OriginField();
        originImpl.setUsername(userName);
        originImpl.setAddress(address);
        originImpl.setSessionId("" + System.currentTimeMillis());
        originImpl.setSessionVersion(System.currentTimeMillis());
        originImpl.setNetworkType("IN");
        originImpl.setAddressType("IP4");
        return originImpl;
    }

    public OriginField createOrigin(String userName, String sessionId, long sessionVersion, String networkType, String addrType, String address) throws SdpException {
        OriginField originImpl = new OriginField();
        originImpl.setUsername(userName);
        originImpl.setAddress(address);
        originImpl.setSessionId(sessionId);
        originImpl.setSessionVersion(sessionVersion);
        originImpl.setAddressType(addrType);
        originImpl.setNetworkType(networkType);
        return originImpl;
    }

    public MediaDescription createMediaDescription(String media, int port, int numPorts, String transport, int[] staticRtpAvpTypes) throws IllegalArgumentException, SdpException {
        MediaDescription mediaDescription = new MediaDescription();
        MediaField mediaImpl = new MediaField();
        mediaImpl.setMediaType(media);
        mediaImpl.setMediaPort(port);
        mediaImpl.setPortCount(numPorts);
        mediaImpl.setProtocol(transport);
        Vector<String> formatsV = new Vector<String>(staticRtpAvpTypes.length);
        int i = 0;
        while (i < staticRtpAvpTypes.length) {
            formatsV.addElement("" + staticRtpAvpTypes[i]);
            ++i;
        }
        mediaImpl.setMediaFormats(formatsV);
        mediaDescription.setMedia(mediaImpl);
        return mediaDescription;
    }

    public MediaDescription createMediaDescription(String media, int port, int numPorts, String transport, String[] formats) {
        MediaDescription mediaDescription = new MediaDescription();
        try {
            MediaField mediaImpl = new MediaField();
            mediaImpl.setMediaType(media);
            mediaImpl.setMediaPort(port);
            mediaImpl.setPortCount(numPorts);
            mediaImpl.setProtocol(transport);
            Vector<String> formatsV = new Vector<String>(formats.length);
            int i = 0;
            while (i < formats.length) {
                formatsV.addElement(formats[i]);
                ++i;
            }
            mediaImpl.setMediaFormats(formatsV);
            mediaDescription.setMedia(mediaImpl);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return mediaDescription;
    }

    public TimeDescription createTimeDescription(TimeField t) throws SdpException {
        TimeDescription timeDescription = new TimeDescription();
        timeDescription.setTime(t);
        return timeDescription;
    }

    public TimeDescription createTimeDescription() throws SdpException {
        TimeDescription timeDescription = new TimeDescription();
        TimeField timeImpl = new TimeField();
        timeImpl.setZero();
        timeDescription.setTime(timeImpl);
        return timeDescription;
    }

    public TimeDescription createTimeDescription(Date start, Date stop) throws SdpException {
        TimeDescription timeDescription = new TimeDescription();
        TimeField timeImpl = new TimeField();
        timeImpl.setStart(start);
        timeImpl.setStop(stop);
        timeDescription.setTime(timeImpl);
        return timeDescription;
    }

    public String formatMulticastAddress(String addr, int ttl, int numAddrs) {
        String res = String.valueOf(addr) + "/" + ttl + "/" + numAddrs;
        return res;
    }

    public ConnectionField createConnection(String netType, String addrType, String addr, int ttl, int numAddrs) throws SdpException {
        ConnectionField connectionImpl = new ConnectionField();
        connectionImpl.setNetworkType(netType);
        connectionImpl.setAddressType(addrType);
        connectionImpl.setAddress(addr);
        return connectionImpl;
    }

    public ConnectionField createConnection(String netType, String addrType, String addr) throws SdpException {
        ConnectionField connectionImpl = new ConnectionField();
        connectionImpl.setNetworkType(netType);
        connectionImpl.setAddressType(addrType);
        connectionImpl.setAddress(addr);
        return connectionImpl;
    }

    public ConnectionField createConnection(String addr, int ttl, int numAddrs) throws SdpException {
        ConnectionField connectionImpl = new ConnectionField();
        connectionImpl.setAddress(addr);
        return connectionImpl;
    }

    public ConnectionField createConnection(String addr) throws SdpException {
        return this.createConnection("IN", "IP4", addr);
    }

    public TimeField createTime(Date start, Date stop) throws SdpException {
        TimeField timeImpl = new TimeField();
        timeImpl.setStart(start);
        timeImpl.setStop(stop);
        return timeImpl;
    }

    public TimeField createTime() throws SdpException {
        TimeField timeImpl = new TimeField();
        timeImpl.setZero();
        return timeImpl;
    }

    public RepeatField createRepeatTime(int repeatInterval, int activeDuration, int[] offsets) {
        RepeatField repeatTimeField = new RepeatField();
        try {
            repeatTimeField.setRepeatInterval(repeatInterval);
            repeatTimeField.setActiveDuration(activeDuration);
            repeatTimeField.setOffsetArray(offsets);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return repeatTimeField;
    }

    public ZoneField createTimeZoneAdjustment(Date d, int offset) {
        ZoneField timeZoneAdjustmentImpl = new ZoneField();
        try {
            Hashtable<Date, Integer> map = new Hashtable<Date, Integer>();
            map.put(d, new Integer(offset));
            timeZoneAdjustmentImpl.setZoneAdjustments(map);
        }
        catch (SdpException s) {
            s.printStackTrace();
        }
        return timeZoneAdjustmentImpl;
    }

    public static Date getDateFromNtp(long ntpTime) {
        return new Date((ntpTime - 2208988800L) * 1000L);
    }

    public static long getNtpTime(Date d) throws SdpParseException {
        if (d == null) {
            return -1L;
        }
        return d.getTime() / 1000L + 2208988800L;
    }
}

