/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core;

import java.util.Hashtable;
import java.util.Vector;
import sip4me.gov.nist.core.Debug;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.StringTokenizer;
import sip4me.gov.nist.core.Token;

public abstract class LexerCore
extends StringTokenizer {
    public static final int START = 2048;
    public static final int END = 4096;
    public static final int ID = 4095;
    public static final int WHITESPACE = 4097;
    public static final int DIGIT = 4098;
    public static final int ALPHA = 4099;
    public static final int BACKSLASH = 92;
    public static final int QUOTE = 39;
    public static final int AT = 64;
    public static final int SP = 32;
    public static final int HT = 9;
    public static final int COLON = 58;
    public static final int STAR = 42;
    public static final int DOLLAR = 36;
    public static final int PLUS = 43;
    public static final int POUND = 35;
    public static final int MINUS = 45;
    public static final int DOUBLEQUOTE = 34;
    public static final int TILDE = 126;
    public static final int BACK_QUOTE = 96;
    public static final int NULL = 0;
    public static final int EQUALS = 61;
    public static final int SEMICOLON = 59;
    public static final int SLASH = 47;
    public static final int L_SQUARE_BRACKET = 91;
    public static final int R_SQUARE_BRACKET = 93;
    public static final int R_CURLY = 125;
    public static final int L_CURLY = 123;
    public static final int HAT = 94;
    public static final int BAR = 124;
    public static final int DOT = 46;
    public static final int EXCLAMATION = 33;
    public static final int LPAREN = 40;
    public static final int RPAREN = 41;
    public static final int GREATER_THAN = 62;
    public static final int LESS_THAN = 60;
    public static final int PERCENT = 37;
    public static final int QUESTION = 63;
    public static final int AND = 38;
    public static final int UNDERSCORE = 95;
    protected static Hashtable globalSymbolTable = new Hashtable();
    protected static Hashtable lexerTables = new Hashtable();
    protected Hashtable currentLexer;
    protected String currentLexerName;
    protected Token currentMatch;

    protected void addKeyword(String name, int value) {
        Integer val = new Integer(value);
        this.currentLexer.put(name, val);
        if (!globalSymbolTable.containsKey(val)) {
            globalSymbolTable.put(val, name);
        }
    }

    public String lookupToken(int value) {
        if (value > 2048) {
            return (String)globalSymbolTable.get(new Integer(value));
        }
        Character ch = new Character((char)value);
        return ch.toString();
    }

    protected Hashtable addLexer(String lexerName) {
        this.currentLexer = (Hashtable)lexerTables.get(lexerName);
        if (this.currentLexer == null) {
            this.currentLexer = new Hashtable();
            lexerTables.put(lexerName, this.currentLexer);
        }
        return this.currentLexer;
    }

    public abstract void selectLexer(String var1);

    protected LexerCore() {
        this.currentLexer = new Hashtable();
        this.currentLexerName = "charLexer";
    }

    public LexerCore(String lexerName) {
        this.selectLexer(lexerName);
    }

    public LexerCore(String lexerName, String buffer) {
        this(lexerName);
        this.buffer = buffer;
    }

    public String peekNextId() {
        int oldPtr = this.ptr;
        String retval = this.ttoken();
        this.savedPtr = this.ptr;
        this.ptr = oldPtr;
        return retval;
    }

    public String getNextId() {
        return this.ttoken();
    }

    public Token getNextToken() {
        return this.currentMatch;
    }

    public Token peekNextToken() throws ParseException {
        return (Token)this.peekNextToken(1).elementAt(0);
    }

    public Vector peekNextToken(int ntokens) throws ParseException {
        int old = this.ptr;
        Vector<Token> retval = new Vector<Token>();
        int i = 0;
        while (i < ntokens) {
            Token tok = new Token();
            if (this.startsId()) {
                String id;
                tok.tokenValue = id = this.ttoken();
                if (this.currentLexer.containsKey(id.toUpperCase())) {
                    Integer type = (Integer)this.currentLexer.get(id.toUpperCase());
                    tok.tokenType = type;
                } else {
                    tok.tokenType = 4095;
                }
            } else {
                char nextChar = this.getNextChar();
                tok.tokenValue = "" + nextChar;
                tok.tokenType = StringTokenizer.isAlpha(nextChar) ? 4099 : (StringTokenizer.isDigit(nextChar) ? 4098 : (int)nextChar);
            }
            retval.addElement(tok);
            ++i;
        }
        this.savedPtr = this.ptr;
        this.ptr = old;
        return retval;
    }

    public Token match(int tok) throws ParseException {
        if (Debug.parserDebug) {
            Debug.println("match " + tok);
        }
        if (tok > 2048 && tok < 4096) {
            if (tok == 4095) {
                if (!this.startsId()) {
                    throw new ParseException(String.valueOf(this.buffer) + "\nID expected", this.ptr);
                }
                String id = this.getNextId();
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = id;
                this.currentMatch.tokenType = 4095;
            } else {
                String nexttok = this.getNextId();
                Integer cur = (Integer)this.currentLexer.get(nexttok.toUpperCase());
                if (cur == null || cur != tok) {
                    throw new ParseException(String.valueOf(this.buffer) + "\nUnexpected Token : " + nexttok, this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = nexttok;
                this.currentMatch.tokenType = tok;
            }
        } else if (tok > 4096) {
            char next = this.lookAhead(0);
            if (tok == 4098) {
                if (!StringTokenizer.isDigit(next)) {
                    throw new ParseException(String.valueOf(this.buffer) + "\nExpecting DIGIT", this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = "" + next;
                this.currentMatch.tokenType = tok;
                this.consume(1);
            } else if (tok == 4099) {
                if (!StringTokenizer.isAlpha(next)) {
                    throw new ParseException(String.valueOf(this.buffer) + "\nExpecting ALPHA", this.ptr);
                }
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = "" + next;
                this.currentMatch.tokenType = tok;
                this.consume(1);
            }
        } else {
            Character ch = new Character((char)tok);
            char next = this.lookAhead(0);
            if (next == ch.charValue()) {
                this.currentMatch = new Token();
                this.currentMatch.tokenValue = "" + ch.charValue();
                this.currentMatch.tokenType = tok;
                this.consume(1);
            } else {
                throw new ParseException(String.valueOf(this.buffer) + "\nExpecting  " + ch.charValue(), this.ptr);
            }
        }
        return this.currentMatch;
    }

    public void SPorHT() {
        try {
            while (this.lookAhead(0) == ' ' || this.lookAhead(0) == '\t') {
                this.consume(1);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public boolean startsId() {
        try {
            char nextChar = this.lookAhead(0);
            return StringTokenizer.isAlpha(nextChar) || StringTokenizer.isDigit(nextChar) || nextChar == '_' || nextChar == '+' || nextChar == '-' || nextChar == '!' || nextChar == '`' || nextChar == '\'' || nextChar == '%' || nextChar == '~' || nextChar == '.' || nextChar == '*';
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public String ttoken() {
        StringBuffer nextId = new StringBuffer();
        try {
            while (this.hasMoreChars()) {
                char nextChar = this.lookAhead(0);
                if (!StringTokenizer.isAlpha(nextChar) && !StringTokenizer.isDigit(nextChar) && nextChar != '_' && nextChar != '+' && nextChar != '-' && nextChar != '!' && nextChar != '`' && nextChar != '\'' && nextChar != '~' && nextChar != '.' && nextChar != '*') break;
                this.consume(1);
                nextId.append(nextChar);
            }
            return nextId.toString();
        }
        catch (ParseException ex) {
            return nextId.toString();
        }
    }

    public String ttokenAllowSpace() {
        StringBuffer nextId = new StringBuffer();
        try {
            while (this.hasMoreChars()) {
                char nextChar = this.lookAhead(0);
                if (!StringTokenizer.isAlpha(nextChar) && !StringTokenizer.isDigit(nextChar) && nextChar != '_' && nextChar != '+' && nextChar != '-' && nextChar != '!' && nextChar != '`' && nextChar != '\'' && nextChar != '~' && nextChar != '.' && nextChar != ' ' && nextChar != '\t' && nextChar != '*') break;
                nextId.append(nextChar);
                this.consume(1);
            }
            return nextId.toString();
        }
        catch (ParseException ex) {
            return nextId.toString();
        }
    }

    public String quotedString() throws ParseException {
        char next;
        StringBuffer retval = new StringBuffer();
        if (this.lookAhead(0) != '\"') {
            return null;
        }
        this.consume(1);
        while ((next = this.getNextChar()) != '\"') {
            if (next == '\\') {
                retval.append(next);
                next = this.getNextChar();
                retval.append(next);
                continue;
            }
            retval.append(next);
        }
        return retval.toString();
    }

    public String comment() throws ParseException {
        char next;
        StringBuffer retval = new StringBuffer();
        if (this.lookAhead(0) != '(') {
            return null;
        }
        this.consume(1);
        while ((next = this.getNextChar()) != ')') {
            if (next == '\u0000') {
                throw new ParseException(String.valueOf(this.buffer) + " :unexpected EOL", this.ptr);
            }
            if (next == '\\') {
                retval.append(next);
                next = this.getNextChar();
                if (next == '\u0000') {
                    throw new ParseException(String.valueOf(this.buffer) + " : unexpected EOL", this.ptr);
                }
                retval.append(next);
                continue;
            }
            retval.append(next);
        }
        return retval.toString();
    }

    public String byteStringNoSemicolon() {
        StringBuffer retval = new StringBuffer();
        try {
            char next;
            while ((next = this.lookAhead(0)) != '\n' && next != ';') {
                this.consume(1);
                retval.append(next);
            }
        }
        catch (ParseException ex) {
            return retval.toString();
        }
        return retval.toString();
    }

    public String byteStringNoComma() {
        StringBuffer retval = new StringBuffer();
        try {
            char next;
            while ((next = this.lookAhead(0)) != '\n' && next != ',') {
                this.consume(1);
                retval.append(next);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retval.toString();
    }

    public static String charAsString(char ch) {
        return new Character(ch).toString();
    }

    public String charAsString(int nchars) {
        StringBuffer retval = new StringBuffer();
        try {
            int i = 0;
            while (i < nchars) {
                retval.append(this.lookAhead(i));
                ++i;
            }
            return retval.toString();
        }
        catch (ParseException ex) {
            return retval.toString();
        }
    }

    public String number() throws ParseException {
        StringBuffer retval = new StringBuffer();
        try {
            char next;
            if (!StringTokenizer.isDigit(this.lookAhead(0))) {
                throw new ParseException(String.valueOf(this.buffer) + ": Unexpected token at " + this.lookAhead(0), this.ptr);
            }
            retval.append(this.lookAhead(0));
            this.consume(1);
            while (StringTokenizer.isDigit(next = this.lookAhead(0))) {
                retval.append(next);
                this.consume(1);
            }
            return retval.toString();
        }
        catch (ParseException ex) {
            return retval.toString();
        }
    }

    public int markInputPosition() {
        return this.ptr;
    }

    public void rewindInputPosition(int position) {
        this.ptr = position;
    }

    public String getRest() {
        if (this.ptr >= this.buffer.length()) {
            return null;
        }
        return this.buffer.substring(this.ptr);
    }

    public String getString(char c) throws ParseException {
        int savedPtr = this.ptr;
        StringBuffer retval = new StringBuffer();
        while (true) {
            char next;
            if ((next = this.lookAhead(0)) == '\u0000') {
                ParseException exception = new ParseException(String.valueOf(this.buffer) + "unexpected EOL", this.ptr);
                this.ptr = savedPtr;
                throw exception;
            }
            if (next == c) break;
            if (next == '\\') {
                this.consume(1);
                char nextchar = this.lookAhead(0);
                if (nextchar == '\u0000') {
                    ParseException exception = new ParseException(String.valueOf(this.buffer) + "unexpected EOL", this.ptr);
                    this.ptr = savedPtr;
                    throw exception;
                }
                this.consume(1);
                retval.append(nextchar);
                continue;
            }
            this.consume(1);
            retval.append(next);
        }
        this.consume(1);
        return retval.toString();
    }

    public int getPtr() {
        return this.ptr;
    }

    public String getBuffer() {
        return this.buffer;
    }

    public ParseException createParseException() {
        return new ParseException(this.buffer, this.ptr);
    }
}

