/*
 * Decompiled with CFR 0.152.
 */
package sip4me.nist.javax.microedition.sip;

import java.util.Vector;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.address.SipURI;
import sip4me.gov.nist.siplite.address.TelURL;
import sip4me.gov.nist.siplite.address.URI;

public class SipAddress {
    private Address address;

    public SipAddress(String address) throws IllegalArgumentException {
        try {
            this.address = StackConnector.addressFactory.createAddress(address);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public SipAddress(String displayName, String URI2) throws IllegalArgumentException {
        try {
            URI uri = StackConnector.addressFactory.createURI(URI2);
            this.address = StackConnector.addressFactory.createAddress(displayName, uri);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }

    public void setDisplayName(String name) throws IllegalArgumentException {
        this.address.setDisplayName(name);
    }

    public String getScheme() {
        return this.address.getURI().getScheme();
    }

    public void setScheme(String scheme) throws IllegalArgumentException {
    }

    public String getUser() {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            return ((SipURI)uri).getUser();
        }
        return ((TelURL)uri).getPhoneNumber();
    }

    public void setUser(String user) throws IllegalArgumentException {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            ((SipURI)uri).setUser(user);
        } else {
            ((TelURL)uri).setPhoneNumber(user);
        }
    }

    public String getURI() {
        return this.address.getURI().toString();
    }

    public void setURI(String URI2) throws IllegalArgumentException {
        URI uri = null;
        try {
            uri = StackConnector.addressFactory.createURI(URI2);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
        if (uri == null) {
            throw new IllegalArgumentException("The URI is invalid");
        }
        this.address.setURI(uri);
    }

    public String getHost() {
        return this.address.getHost();
    }

    public void setHost(String host) throws IllegalArgumentException {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            try {
                ((SipURI)uri).setHost(host);
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        } else {
            ((TelURL)uri).setPostDial(host);
        }
    }

    public int getPort() {
        return this.address.getPort();
    }

    public void setPort(int port) throws IllegalArgumentException {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            ((SipURI)uri).setPort(port);
        }
    }

    public String getParameter(String name) {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            return ((SipURI)uri).getParameter(name);
        }
        return null;
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            try {
                ((SipURI)uri).setParameter(name, value);
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        }
    }

    public void removeParameter(String name) {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            ((SipURI)uri).removeParameter(name);
        }
    }

    public String[] getParameterNames() {
        URI uri = this.address.getURI();
        if (uri.isSipURI()) {
            Vector parameterNameList = ((SipURI)uri).getParameterNames();
            String[] parameterNames = new String[parameterNameList.size()];
            int i = 0;
            while (i < parameterNameList.size()) {
                parameterNames[i] = (String)parameterNameList.elementAt(i);
                ++i;
            }
            return parameterNames;
        }
        return null;
    }

    public String toString() {
        return this.address.encode();
    }
}

