/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.SocketConnection;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.FromHeader;
import sip4me.gov.nist.siplite.header.RequestLine;
import sip4me.gov.nist.siplite.header.StatusLine;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.header.ViaList;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.parser.ParseExceptionListener;
import sip4me.gov.nist.siplite.parser.StringMsgParser;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.MessageProcessor;
import sip4me.gov.nist.siplite.stack.SIPMessageStack;
import sip4me.gov.nist.siplite.stack.SIPServerException;
import sip4me.gov.nist.siplite.stack.SIPServerRequestInterface;
import sip4me.gov.nist.siplite.stack.SIPServerResponseInterface;
import sip4me.gov.nist.siplite.stack.ServerLog;
import sip4me.gov.nist.siplite.stack.UDPMessageProcessor;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable {
    protected SIPMessageStack stack;
    private String myAddress;
    private int myPort;
    protected StringMsgParser myParser;
    private String peerAddress;
    private int peerPort;
    private String peerProtocol;
    private int peerPacketSourcePort;
    private String peerPacketSourceAddress;
    private Datagram incomingPacket;
    private long receptionTime;
    private String key;
    protected static Hashtable duplicates;

    public UDPMessageChannel(SIPMessageStack stack, UDPMessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
        this.stack = stack;
        this.myAddress = messageProcessor.getSIPStack().getHostAddress();
        this.myPort = messageProcessor.getPort();
        Thread mythread = new Thread((Runnable)this, "UDPMessageChannelThread");
        mythread.start();
    }

    public UDPMessageChannel(Datagram packet, SIPMessageStack sipStack, MessageProcessor messageProcessor) {
        this.incomingPacket = packet;
        this.stack = sipStack;
        this.messageProcessor = messageProcessor;
        this.myAddress = sipStack.getHostAddress();
        this.myPort = messageProcessor.getPort();
        Thread mythread = new Thread((Runnable)this, "UDPMessageChannelThread");
        mythread.start();
    }

    public UDPMessageChannel(String targetAddr, int port, SIPMessageStack sipStack, UDPMessageProcessor processor) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "DEBUG, UDPMessageChannel, UDPMessageChannel(), Creating message channel on " + targetAddr + "/" + port);
        }
        this.stack = sipStack;
        this.peerPort = port;
        this.peerAddress = targetAddr;
        this.messageProcessor = processor;
        this.myPort = processor.getPort();
        this.myAddress = sipStack.getHostAddress();
        this.peerProtocol = "UDP";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        do {
            block15: {
                block14: {
                    block13: {
                        if (this.myParser == null) {
                            this.myParser = new StringMsgParser();
                            this.myParser.setParseExceptionListener(this);
                        }
                        if (this.stack.threadPoolSize == -1) break block14;
                        var2_2 = ((UDPMessageProcessor)this.messageProcessor).messageQueue;
                        synchronized (var2_2) {
                            while (true) lbl-1000:
                            // 3 sources

                            {
                                if (!((UDPMessageProcessor)this.messageProcessor).messageQueue.isEmpty()) {
                                    packet = (Datagram)((UDPMessageProcessor)this.messageProcessor).messageQueue.firstElement();
                                    ((UDPMessageProcessor)this.messageProcessor).messageQueue.removeElementAt(0);
                                    break block13;
                                }
                                if (!((UDPMessageProcessor)this.messageProcessor).running) {
                                    return;
                                }
                                try {
                                    ((UDPMessageProcessor)this.messageProcessor).messageQueue.wait();
                                }
                                catch (InterruptedException ex) {
                                    if (!((UDPMessageProcessor)this.messageProcessor).running) ** break;
                                    continue;
                                    return;
                                }
                                break;
                            }
                            ** GOTO lbl-1000
                        }
                    }
                    this.incomingPacket = packet;
                    break block15;
                }
                packet = this.incomingPacket;
            }
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Processing new incoming datagram " + packet.getLength());
            }
            try {
                this.processIncomingDataPacket(packet);
            }
            catch (Throwable e) {
                if (!LogWriter.needsLogging) continue;
                LogWriter.logMessage(2, "Exception processing incoming UDP packet");
                LogWriter.logException((Exception)e);
            }
        } while (this.stack.threadPoolSize != -1);
    }

    private void processIncomingDataPacket(Datagram packet) throws Exception {
        String address = packet.getAddress();
        try {
            int firstColon = address.indexOf("//");
            int secondColon = address.indexOf(":", firstColon + 1);
            this.peerAddress = address.substring(firstColon + 2, secondColon);
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "UDPMessageChannel, run(), sender address:" + this.peerAddress);
            }
            String senderPortString = address.substring(address.indexOf(";") + 1, address.indexOf("|"));
            this.peerPacketSourcePort = Integer.parseInt(senderPortString);
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "UDPMessageChannel, run(), sender port:" + this.peerPacketSourcePort);
            }
        }
        catch (NumberFormatException e) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(2, "UDPMessageChannel, run(), exception raised: " + e.getMessage());
            }
            e.printStackTrace();
            this.peerPacketSourcePort = -1;
        }
        int packetLength = packet.getLength();
        byte[] msgBytes = packet.getData();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "UDPMessageChannel: processIncomingDataPacket : peerAddress = " + this.peerAddress + "/" + this.peerPacketSourcePort + " Length = " + packetLength + " msgBytes " + msgBytes);
        }
        Message sipMessage = null;
        try {
            this.receptionTime = System.currentTimeMillis();
            sipMessage = this.myParser.parseSIPMessage(msgBytes);
            this.myParser = null;
        }
        catch (ParseException ex) {
            String msgString;
            this.myParser = null;
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Rejecting message !  " + new String(msgBytes));
                LogWriter.logMessage(32, "error message " + ex.getMessage());
                LogWriter.logException(ex);
            }
            if (!(msgString = new String(msgBytes, 0, packetLength)).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.create400Response(msgString, ex);
                if (badReqRes != null) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(32, "Sending automatic 400 Bad Request: " + badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.peerAddress, this.peerPacketSourcePort, "UDP", false);
                    }
                    catch (IOException e) {
                        LogWriter.logException(e);
                    }
                } else if (LogWriter.needsLogging) {
                    LogWriter.logMessage(32, "Could not formulate automatic 400 Bad Request");
                }
            }
            return;
        }
        if (sipMessage == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Rejecting message !  + Null message parsed.");
            }
            return;
        }
        ViaList viaList = sipMessage.getViaHeaders();
        if (sipMessage.getFromHeader() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeqHeader() == null || sipMessage.getViaHeaders() == null) {
            String badmsg = new String(msgBytes);
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("bad message " + badmsg);
                LogWriter.logMessage(">>> Dropped Bad Msg FromHeader = " + sipMessage.getFromHeader() + "ToHeader = " + sipMessage.getTo() + "CallId = " + sipMessage.getCallId() + "CSeqHeader = " + sipMessage.getCSeqHeader() + "Via = " + sipMessage.getViaHeaders());
            }
            this.stack.logBadMessage(badmsg);
            return;
        }
        if (sipMessage instanceof Request) {
            ViaHeader v = (ViaHeader)viaList.first();
            this.peerPort = v.hasPort() ? v.getPort() : 5060;
            this.peerProtocol = v.getTransport();
            boolean hasRPort = v.hasParameter("rport");
            if (hasRPort || !this.peerAddress.equals(v.getHost())) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(16, "WARNING! \"Received\" parameter has been temporarily disabled. Response will be sent to topmost Via Host: " + v.getHost());
                }
                this.peerAddress = v.getHost();
            }
            if (hasRPort) {
                v.setParameter("rport", Integer.toString(this.peerPacketSourcePort));
                this.peerPort = this.peerPacketSourcePort;
            }
        } else {
            this.peerPort = this.peerPacketSourcePort;
            this.peerProtocol = ((ViaHeader)viaList.getFirst()).getTransport();
        }
        this.processMessage(sipMessage);
    }

    public void processMessage(Message sipMessage) {
        block16: {
            if (sipMessage instanceof Request) {
                Request sipRequest = (Request)sipMessage;
                SIPServerRequestInterface sipServerRequest = this.stack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest == null) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Null request interface returned");
                    }
                    return;
                }
                try {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("About to process " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                    }
                    sipServerRequest.processRequest(sipRequest, this);
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Done processing " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                    }
                    if (!ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) break block16;
                    if (sipServerRequest.getProcessingInfo() == null) {
                        ServerLog.logMessage(sipMessage, String.valueOf(sipRequest.getViaHost()) + ":" + sipRequest.getViaPort(), String.valueOf(this.stack.getHostAddress()) + ":" + this.stack.getPort(this.getTransport()), false, new Long(this.receptionTime).toString());
                        break block16;
                    }
                    ServerLog.logMessage(sipMessage, String.valueOf(sipRequest.getViaHost()) + ":" + sipRequest.getViaPort(), String.valueOf(this.stack.getHostAddress()) + ":" + this.stack.getPort(this.getTransport()), sipServerRequest.getProcessingInfo(), false, new Long(this.receptionTime).toString());
                }
                catch (SIPServerException ex) {
                    if (ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
                        ServerLog.logMessage(sipMessage, String.valueOf(sipRequest.getViaHost()) + ":" + sipRequest.getViaPort(), String.valueOf(this.stack.getHostAddress()) + ":" + this.stack.getPort(this.getTransport()), ex.getMessage(), false, new Long(this.receptionTime).toString());
                    }
                    this.handleException(ex);
                }
            } else {
                Response sipResponse = (Response)sipMessage;
                SIPServerResponseInterface sipServerResponse = this.stack.newSIPServerResponse(sipResponse, this);
                try {
                    if (sipServerResponse != null) {
                        sipServerResponse.processResponse(sipResponse, this);
                    } else if (LogWriter.needsLogging) {
                        LogWriter.logMessage("null sipServerResponse!");
                    }
                }
                catch (SIPServerException ex) {
                    if (ServerLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
                        this.logResponse(sipResponse, this.receptionTime, String.valueOf(ex.getMessage()) + "-- Dropped!");
                    }
                    ServerLog.logException(ex);
                }
            }
        }
    }

    public void sendMessage(Message sipMessage) throws IOException {
        byte[] msg = sipMessage.encodeAsBytes();
        this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol, sipMessage instanceof Request);
    }

    protected void sendMessage(byte[] msg, String receiverAddress, int receiverPort, boolean reconnect) throws IOException {
        if (receiverPort == -1) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("DEBUG, UDPMessageChannel, sendMessage(), The message is not sent: the receiverPort=-1");
            }
            throw new IOException("Receiver port not set ");
        }
        try {
            DatagramConnection socket;
            boolean created = false;
            if (this.stack.udpFlag) {
                socket = ((UDPMessageProcessor)this.messageProcessor).dc;
            } else {
                String url = "datagram://" + this.peerAddress + ":" + this.peerPort;
                socket = (DatagramConnection)Connector.open((String)url);
                created = true;
            }
            Datagram reply = socket.newDatagram(msg, msg.length);
            socket.send(reply);
            if (created) {
                socket.close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] msg, String receiverAddress, int receiverPort, String receiverProtocol, boolean retry) throws IOException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Sending message to [" + receiverAddress + ":" + receiverPort + "/" + receiverProtocol + "]\n" + new String(msg) + "  to be sent to  ");
        }
        if (receiverPort == -1) {
            if (!LogWriter.needsLogging) throw new IOException("Receiver port not set ");
            LogWriter.logMessage("DEBUG, UDPMessageChannel, sendMessage(), The message is not sent: the receiverPort=-1");
            throw new IOException("Receiver port not set ");
        }
        if (Utils.compareToIgnoreCase(receiverProtocol, "UDP") == 0) {
            try {
                Datagram reply;
                DatagramConnection socket;
                boolean created = false;
                if (this.stack.udpFlag) {
                    socket = ((UDPMessageProcessor)this.messageProcessor).dc;
                    reply = socket.newDatagram(msg, msg.length);
                    reply.setAddress("datagram://" + this.peerAddress + ":" + this.peerPort);
                } else {
                    socket = this.stack.getNetworkLayer().createDatagramSocket(this.peerAddress, this.peerPort);
                    reply = socket.newDatagram(msg, msg.length);
                    created = true;
                }
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(32, "UDPMessageChannel, sendMessage(), Sending message over UDP, using socket " + socket + " created " + created + " destination " + reply.getAddress());
                }
                socket.send(reply);
                if (!created) return;
                socket.close();
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return;
            }
        } else {
            SocketConnection outputSocket = this.stack.ioHandler.sendBytes(this.peerAddress, this.peerPort, "tcp", msg, retry);
            OutputStream myOutputStream = this.stack.ioHandler.getSocketOutputStream(outputSocket);
            myOutputStream.write(msg, 0, msg.length);
            myOutputStream.flush();
        }
    }

    public SIPMessageStack getSIPStack() {
        return this.stack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.stack.stackAddress;
    }

    public int getPort() {
        return this.myPort;
    }

    public void handleException(SIPServerException ex) {
        int rc = ex.getRC();
        Request request = (Request)ex.getSIPMessage();
        String msgString = ex.getMessage();
        if (rc != 0) {
            Response response = request.createResponse(rc, msgString);
            try {
                this.sendMessage(response);
            }
            catch (IOException ioex) {
                ServerLog.logException(ioex);
            }
        } else {
            try {
                this.sendMessage(msgString);
            }
            catch (IOException ioex) {
                ServerLog.logException(ioex);
            }
        }
    }

    public boolean equals(Object other) {
        boolean retval;
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            retval = false;
        } else {
            UDPMessageChannel that = (UDPMessageChannel)other;
            retval = this.peerAddress.equals(that.peerAddress);
        }
        return retval;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = "UDP:" + this.stack.ioHandler.makeKey(this.peerAddress, this.peerPort);
        }
        return this.key;
    }

    private final String create400Response(String badReq, ParseException pe) {
        StringBuffer buf = new StringBuffer(512);
        buf.append("SIP/2.0 400 Bad Request (" + pe.getMessage() + ')');
        if (!UDPMessageChannel.copyViaHeaders(badReq, buf)) {
            return null;
        }
        if (!UDPMessageChannel.copyHeader("CSeq", badReq, buf)) {
            return null;
        }
        if (!UDPMessageChannel.copyHeader("Call-Id", badReq, buf)) {
            return null;
        }
        if (!UDPMessageChannel.copyHeader("From", badReq, buf)) {
            return null;
        }
        if (!UDPMessageChannel.copyHeader("To", badReq, buf)) {
            return null;
        }
        int toStart = buf.toString().indexOf("To");
        if (toStart != -1 && buf.toString().indexOf("tag", toStart) == -1) {
            buf.append(";tag=badreq");
        }
        return buf.toString();
    }

    private static final boolean copyHeader(String name, String fromReq, StringBuffer buf) {
        int end;
        int start = fromReq.indexOf(name);
        if (start != -1 && (end = fromReq.indexOf("\r\n", start)) != -1) {
            buf.append(fromReq.substring(start - 2, end));
            return true;
        }
        return false;
    }

    private static final boolean copyViaHeaders(String fromReq, StringBuffer buf) {
        int start = fromReq.indexOf("Via");
        boolean found = false;
        while (start != -1) {
            int end = fromReq.indexOf("\r\n", start);
            if (end != -1) {
                buf.append(fromReq.substring(start - 2, end));
                found = true;
                start = fromReq.indexOf("Via", end);
                continue;
            }
            return false;
        }
        return found;
    }

    private void sendMessage(String msg) throws IOException {
        this.sendMessage(msg.getBytes(), this.peerAddress, this.peerPort, this.peerProtocol, false);
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public void close() {
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public boolean isSecure() {
        return false;
    }

    public void handleException(ParseException ex, Message sipMessage, Class hdrClass, String headerText, String messageText) throws ParseException {
        if (LogWriter.needsLogging) {
            LogWriter.logException(ex);
        }
        if (hdrClass.equals(FromHeader.clazz) || hdrClass.equals(ToHeader.clazz) || hdrClass.equals(CSeqHeader.clazz) || hdrClass.equals(ViaHeader.clazz) || hdrClass.equals(CallIdHeader.clazz) || hdrClass.equals(RequestLine.clazz) || hdrClass.equals(StatusLine.clazz)) {
            this.stack.logBadMessage(messageText);
            throw ex;
        }
        sipMessage.addUnparsed(headerText);
    }
}

