/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.address;

import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.StringTokenizer;
import sip4me.gov.nist.core.Utils;

public class Hop {
    protected String host;
    protected int port;
    protected String transport;
    protected boolean explicitRoute;
    protected boolean defaultRoute;
    protected boolean uriRoute;

    public String toString() {
        return String.valueOf(this.host) + ":" + this.port + "/" + this.transport;
    }

    public boolean equals(Object other) {
        if (other.getClass().equals(this.getClass())) {
            Hop otherhop = (Hop)other;
            return otherhop.host.equals(this.host) && otherhop.port == this.port;
        }
        return false;
    }

    public Hop(String hostName, int portNumber, String trans) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("create hop for " + hostName + ":" + portNumber + "/" + trans);
        }
        this.host = hostName;
        this.port = portNumber;
        this.transport = trans == null ? "UDP" : (trans == "" ? "UDP" : trans);
    }

    public Hop(String hop) throws IllegalArgumentException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("create hop for " + hop);
        }
        if (hop == null) {
            throw new IllegalArgumentException("Null arg!");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(String.valueOf(hop) + "/");
            String hostPort = stringTokenizer.getNextToken('/');
            stringTokenizer.getNextChar();
            this.transport = stringTokenizer.getNextToken('/').trim();
            if (this.transport == null) {
                this.transport = "UDP";
            } else if (this.transport == "") {
                this.transport = "UDP";
            }
            if (Utils.compareToIgnoreCase(this.transport, "UDP") != 0 && Utils.compareToIgnoreCase(this.transport, "TCP") != 0) {
                System.out.println("Bad transport string " + this.transport);
                throw new IllegalArgumentException(hop);
            }
            stringTokenizer = new StringTokenizer(String.valueOf(hostPort) + ":");
            this.host = stringTokenizer.getNextToken(':');
            if (this.host == null || this.host.equals("")) {
                throw new IllegalArgumentException("no host!");
            }
            stringTokenizer.consume(1);
            String portString = null;
            portString = stringTokenizer.getNextToken(':');
            if (portString == null || portString.equals("")) {
                this.port = 5060;
            } else {
                try {
                    this.port = Integer.parseInt(portString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Bad port spec");
                }
            }
            this.defaultRoute = true;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad hop");
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isExplicitRoute() {
        return this.explicitRoute;
    }

    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public boolean isURIRoute() {
        return this.uriRoute;
    }

    public void setURIRouteFlag() {
        this.uriRoute = true;
    }

    public void setDefaultRouteFlag() {
        this.defaultRoute = true;
    }

    public void setExplicitRouteFlag() {
        this.explicitRoute = true;
    }
}

