/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.sip;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.microedition.sip.SipDialogImpl;
import sip4me.gov.nist.microedition.sip.SipServerConnectionImpl;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.ObjectInUseException;
import sip4me.gov.nist.siplite.SipProvider;
import sip4me.gov.nist.siplite.SipStack;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.stack.Dialog;
import sip4me.gov.nist.siplite.stack.ServerTransaction;
import sip4me.nist.javax.microedition.sip.SipConnectionNotifier;
import sip4me.nist.javax.microedition.sip.SipDialog;
import sip4me.nist.javax.microedition.sip.SipException;
import sip4me.nist.javax.microedition.sip.SipServerConnection;
import sip4me.nist.javax.microedition.sip.SipServerConnectionListener;

public class SipConnectionNotifierImpl
implements SipConnectionNotifier {
    private SipServerConnectionListener sipServerConnectionListener = null;
    private Vector messageQueue = null;
    private boolean connectionOpen;
    private String localAddress = null;
    private final int portNumber;
    private SipProvider sipProvider = null;
    private StackConnector stackConnector = null;

    protected SipConnectionNotifierImpl(SipProvider sipProvider, String localAddress, int portNumber) {
        this.sipProvider = sipProvider;
        this.localAddress = localAddress;
        this.portNumber = portNumber;
        this.connectionOpen = true;
        this.messageQueue = new Vector();
        try {
            this.stackConnector = StackConnector.getInstance();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipServerConnection acceptAndOpen() throws IOException, InterruptedIOException, SipException {
        if (!this.connectionOpen) {
            throw new InterruptedIOException("Connection was closed!");
        }
        if (this.messageQueue == null || this.messageQueue.size() < 1) {
            SipConnectionNotifierImpl sipConnectionNotifierImpl = this;
            synchronized (sipConnectionNotifierImpl) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                catch (IllegalMonitorStateException imse) {
                    imse.printStackTrace();
                }
            }
        }
        Request request = (Request)this.messageQueue.firstElement();
        this.messageQueue.removeElement(request);
        SipDialog sipDialog = null;
        ServerTransaction serverTransaction = (ServerTransaction)request.getTransaction();
        Dialog dialog = serverTransaction.getDialog();
        if (request.getMethod().equals("INVITE") || request.getMethod().equals("SUBSCRIBE")) {
            sipDialog = new SipDialogImpl(dialog, this, request.getFromHeader().getAddress().getURI());
            this.stackConnector.sipDialogList.addElement(sipDialog);
        } else {
            sipDialog = dialog != null ? this.stackConnector.findDialog(dialog.getDialogId()) : null;
        }
        SipServerConnectionImpl sipServerConnection = new SipServerConnectionImpl(request, sipDialog, this);
        return sipServerConnection;
    }

    public void setListener(SipServerConnectionListener sscl) throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection was closed!");
        }
        this.sipServerConnectionListener = sscl;
    }

    public String getLocalAddress() throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection was closed!");
        }
        return this.localAddress;
    }

    public void setLocalAddress(String newLocalAddress) throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection was closed!");
        }
        this.localAddress = newLocalAddress;
    }

    public int getLocalPort() throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection was closed!");
        }
        return this.portNumber;
    }

    public void close() throws IOException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Closing SipConnectionNotifier at " + this.localAddress + ":" + this.portNumber);
        }
        StackConnector.getInstance().connectionNotifiersList.removeElement(this);
        SipStack sipStack = this.sipProvider.getSipStack();
        try {
            sipStack.deleteSipProvider(this.sipProvider);
        }
        catch (ObjectInUseException oiue) {
            throw new IOException(oiue.getMessage());
        }
        this.connectionOpen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRequestReceived(Request request) {
        this.messageQueue.addElement(request);
        if (this.sipServerConnectionListener != null) {
            this.sipServerConnectionListener.notifyRequest(this);
        }
        SipConnectionNotifierImpl sipConnectionNotifierImpl = this;
        synchronized (sipConnectionNotifierImpl) {
            try {
                this.notify();
            }
            catch (IllegalMonitorStateException imse) {
                imse.printStackTrace();
            }
        }
    }

    protected SipProvider getSipProvider() {
        return this.sipProvider;
    }

    public boolean isSharedMode() {
        return false;
    }
}

