/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp;

import java.util.Vector;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.javax.sdp.MediaDescription;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.TimeDescription;
import sip4me.gov.nist.javax.sdp.fields.AttributeField;
import sip4me.gov.nist.javax.sdp.fields.BandwidthField;
import sip4me.gov.nist.javax.sdp.fields.ConnectionField;
import sip4me.gov.nist.javax.sdp.fields.EmailField;
import sip4me.gov.nist.javax.sdp.fields.InformationField;
import sip4me.gov.nist.javax.sdp.fields.KeyField;
import sip4me.gov.nist.javax.sdp.fields.MediaField;
import sip4me.gov.nist.javax.sdp.fields.OriginField;
import sip4me.gov.nist.javax.sdp.fields.PhoneField;
import sip4me.gov.nist.javax.sdp.fields.ProtoVersionField;
import sip4me.gov.nist.javax.sdp.fields.RepeatField;
import sip4me.gov.nist.javax.sdp.fields.SDPField;
import sip4me.gov.nist.javax.sdp.fields.SessionNameField;
import sip4me.gov.nist.javax.sdp.fields.TimeField;
import sip4me.gov.nist.javax.sdp.fields.URIField;
import sip4me.gov.nist.javax.sdp.fields.ZoneField;

public class SessionDescription {
    private TimeDescription currentTimeDescription;
    private MediaDescription currentMediaDescription;
    protected ProtoVersionField versionImpl;
    protected OriginField originImpl;
    protected SessionNameField sessionNameImpl;
    protected InformationField infoImpl;
    protected URIField uriImpl;
    protected ConnectionField connectionImpl;
    protected KeyField keyImpl;
    protected Vector timeDescriptions;
    protected Vector mediaDescriptions;
    protected Vector zoneAdjustments = new Vector();
    protected Vector emailList = new Vector();
    protected Vector phoneList = new Vector();
    protected Vector bandwidthList = new Vector();
    protected Vector attributesList;

    public SessionDescription() {
        this.timeDescriptions = new Vector();
        this.mediaDescriptions = new Vector();
        this.attributesList = new Vector();
    }

    public void addField(SDPField sdpField) throws ParseException {
        try {
            if (sdpField instanceof ProtoVersionField) {
                this.versionImpl = (ProtoVersionField)sdpField;
            } else if (sdpField instanceof OriginField) {
                this.originImpl = (OriginField)sdpField;
            } else if (sdpField instanceof SessionNameField) {
                this.sessionNameImpl = (SessionNameField)sdpField;
            } else if (sdpField instanceof InformationField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setInformationField((InformationField)sdpField);
                } else {
                    this.infoImpl = (InformationField)sdpField;
                }
            } else if (sdpField instanceof URIField) {
                this.uriImpl = (URIField)sdpField;
            } else if (sdpField instanceof ConnectionField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setConnectionField((ConnectionField)sdpField);
                } else {
                    this.connectionImpl = (ConnectionField)sdpField;
                }
            } else if (sdpField instanceof KeyField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setKey((KeyField)sdpField);
                } else {
                    this.keyImpl = (KeyField)sdpField;
                }
            } else if (sdpField instanceof EmailField) {
                this.emailList.addElement(sdpField);
            } else if (sdpField instanceof PhoneField) {
                this.phoneList.addElement(sdpField);
            } else if (sdpField instanceof TimeField) {
                this.currentTimeDescription = new TimeDescription((TimeField)sdpField);
                this.timeDescriptions.addElement(this.currentTimeDescription);
            } else if (sdpField instanceof RepeatField) {
                if (this.currentTimeDescription == null) {
                    throw new ParseException("no time specified", 0);
                }
                this.currentTimeDescription.addRepeatField((RepeatField)sdpField);
            } else if (sdpField instanceof ZoneField) {
                this.zoneAdjustments.addElement(sdpField);
            } else if (sdpField instanceof BandwidthField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.addBandwidthField((BandwidthField)sdpField);
                } else {
                    this.bandwidthList.addElement(sdpField);
                }
            } else if (sdpField instanceof AttributeField) {
                if (this.currentMediaDescription != null) {
                    AttributeField af = (AttributeField)sdpField;
                    String s = af.getName();
                    this.currentMediaDescription.addAttribute((AttributeField)sdpField);
                } else {
                    this.attributesList.addElement(sdpField);
                }
            } else if (sdpField instanceof MediaField) {
                this.currentMediaDescription = new MediaDescription();
                this.mediaDescriptions.addElement(this.currentMediaDescription);
                this.currentMediaDescription.setMediaField((MediaField)sdpField);
            }
        }
        catch (SdpException ex) {
            throw new ParseException(sdpField.encode(), 0);
        }
    }

    public Object clone() {
        SessionDescription hi;
        Class<?> myClass = this.getClass();
        try {
            hi = (SessionDescription)myClass.newInstance();
        }
        catch (InstantiationException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        hi.versionImpl = (ProtoVersionField)this.versionImpl.clone();
        hi.originImpl = (OriginField)this.originImpl.clone();
        hi.sessionNameImpl = (SessionNameField)this.sessionNameImpl.clone();
        hi.infoImpl = (InformationField)this.infoImpl.clone();
        hi.uriImpl = (URIField)this.uriImpl.clone();
        hi.connectionImpl = (ConnectionField)this.connectionImpl.clone();
        hi.keyImpl = (KeyField)this.keyImpl.clone();
        hi.timeDescriptions = this.cloneVector(this.timeDescriptions);
        hi.emailList = this.cloneVector(this.emailList);
        hi.phoneList = this.cloneVector(this.phoneList);
        hi.zoneAdjustments = this.cloneVector(this.zoneAdjustments);
        hi.bandwidthList = this.cloneVector(this.bandwidthList);
        hi.attributesList = this.cloneVector(this.attributesList);
        hi.mediaDescriptions = this.cloneVector(this.mediaDescriptions);
        return hi;
    }

    public ProtoVersionField getVersion() {
        return this.versionImpl;
    }

    public void setVersion(ProtoVersionField v) throws SdpException {
        if (v == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(v instanceof ProtoVersionField)) {
            throw new SdpException("The parameter must be an instance of VersionField");
        }
        this.versionImpl = v;
    }

    public OriginField getOrigin() {
        return this.originImpl;
    }

    public void setOrigin(OriginField origin) throws SdpException {
        OriginField o;
        if (origin == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(origin instanceof OriginField)) {
            throw new SdpException("The parameter must be an instance of OriginField");
        }
        this.originImpl = o = origin;
    }

    public SessionNameField getSessionName() {
        return this.sessionNameImpl;
    }

    public void setSessionName(SessionNameField sessionName) throws SdpException {
        SessionNameField s;
        if (sessionName == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(sessionName instanceof SessionNameField)) {
            throw new SdpException("The parameter must be an instance of SessionNameField");
        }
        this.sessionNameImpl = s = sessionName;
    }

    public InformationField getInfo() {
        return this.infoImpl;
    }

    public void setInfo(InformationField i) throws SdpException {
        InformationField info;
        if (i == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(i instanceof InformationField)) {
            throw new SdpException("The parameter must be an instance of InformationField");
        }
        this.infoImpl = info = i;
    }

    public URIField getURI() {
        return this.uriImpl;
    }

    public void setURI(URIField uri) throws SdpException {
        URIField u;
        if (uri == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(uri instanceof URIField)) {
            throw new SdpException("The parameter must be an instance of URIField");
        }
        this.uriImpl = u = uri;
    }

    public Vector getEmails(boolean create) throws SdpParseException {
        if (this.emailList == null && create) {
            this.emailList = new Vector();
        }
        return this.emailList;
    }

    public void setEmails(Vector emails) throws SdpException {
        if (emails == null) {
            throw new SdpException("The parameter is null");
        }
        this.emailList = emails;
    }

    public Vector getPhones(boolean create) throws SdpException {
        if (this.phoneList == null && create) {
            this.phoneList = new Vector();
        }
        return this.phoneList;
    }

    public void setPhones(Vector phones) throws SdpException {
        if (phones == null) {
            throw new SdpException("The parameter is null");
        }
        this.phoneList = phones;
    }

    public Vector getTimeDescriptions(boolean create) throws SdpException {
        if (this.timeDescriptions == null && create) {
            this.timeDescriptions = new Vector();
        }
        return this.timeDescriptions;
    }

    public void setTimeDescriptions(Vector times) throws SdpException {
        if (times == null) {
            throw new SdpException("The parameter is null");
        }
        this.timeDescriptions = times;
    }

    public Vector getZoneAdjustments(boolean create) throws SdpException {
        if (this.zoneAdjustments == null && create) {
            this.zoneAdjustments = new Vector();
        }
        return this.zoneAdjustments;
    }

    public void setZoneAdjustments(Vector zoneAdjustments) throws SdpException {
        if (zoneAdjustments == null) {
            throw new SdpException("The parameter is null");
        }
        this.zoneAdjustments = zoneAdjustments;
    }

    public ConnectionField getConnection() {
        return this.connectionImpl;
    }

    public void setConnection(ConnectionField conn) throws SdpException {
        ConnectionField c;
        if (conn == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(conn instanceof ConnectionField)) {
            throw new SdpException("Bad implementation class ConnectionField");
        }
        this.connectionImpl = c = conn;
    }

    public Vector getBandwidths(boolean create) {
        if (this.bandwidthList == null && create) {
            this.bandwidthList = new Vector();
        }
        return this.bandwidthList;
    }

    public void setBandwidths(Vector bandwidthList) throws SdpException {
        if (bandwidthList == null) {
            throw new SdpException("The parameter is null");
        }
        this.bandwidthList = bandwidthList;
    }

    public int getBandwidth(String name) throws SdpParseException {
        if (name == null) {
            return -1;
        }
        if (this.bandwidthList == null) {
            return -1;
        }
        int i = 0;
        while (i < this.bandwidthList.size()) {
            BandwidthField b;
            String type;
            Object o = this.bandwidthList.elementAt(i);
            if (o instanceof BandwidthField && (type = (b = (BandwidthField)o).getType()) != null && name.equals(type)) {
                return b.getValue();
            }
            ++i;
        }
        return -1;
    }

    public void setBandwidth(String name, int value) throws SdpException {
        if (name == null) {
            throw new SdpException("The parameter is null");
        }
        if (this.bandwidthList != null) {
            int i = 0;
            while (i < this.bandwidthList.size()) {
                BandwidthField b;
                String type;
                Object o = this.bandwidthList.elementAt(i);
                if (o instanceof BandwidthField && (type = (b = (BandwidthField)o).getType()) != null && name.equals(type)) {
                    b.setValue(value);
                }
                ++i;
            }
        }
    }

    public void removeBandwidth(String name) {
        if (name != null && this.bandwidthList != null) {
            int i = 0;
            while (i < this.bandwidthList.size()) {
                Object o = this.bandwidthList.elementAt(i);
                if (o instanceof BandwidthField) {
                    BandwidthField b = (BandwidthField)o;
                    try {
                        String type = b.getType();
                        if (type != null && name.equals(type)) {
                            this.bandwidthList.removeElement(b);
                        }
                    }
                    catch (SdpParseException sdpParseException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public KeyField getKey() {
        return this.keyImpl;
    }

    public void setKey(KeyField key) throws SdpException {
        KeyField k;
        if (key == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(key instanceof KeyField)) {
            throw new SdpException("The parameter must be an instance of KeyField");
        }
        this.keyImpl = k = key;
    }

    public String getAttribute(String name) throws SdpParseException {
        if (name == null) {
            return null;
        }
        if (this.attributesList == null) {
            return null;
        }
        int i = 0;
        while (i < this.attributesList.size()) {
            AttributeField a;
            String n;
            Object o = this.attributesList.elementAt(i);
            if (o instanceof AttributeField && (n = (a = (AttributeField)o).getName()) != null && name.equals(n)) {
                return a.getValue();
            }
            ++i;
        }
        return null;
    }

    public Vector getAttributes(boolean create) {
        if (this.attributesList == null && create) {
            this.attributesList = new Vector();
        }
        return this.attributesList;
    }

    public void removeAttribute(String name) {
        if (name != null && this.attributesList != null) {
            int i = 0;
            while (i < this.attributesList.size()) {
                Object o = this.attributesList.elementAt(i);
                if (o instanceof AttributeField) {
                    AttributeField a = (AttributeField)o;
                    try {
                        String n = a.getName();
                        if (n != null && name.equals(n)) {
                            this.attributesList.removeElement(a);
                        }
                    }
                    catch (SdpParseException sdpParseException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public void setAttribute(String name, String value) throws SdpException {
        if (name == null) {
            throw new SdpException("The parameter name is null");
        }
        if (this.attributesList != null) {
            int i = 0;
            while (i < this.attributesList.size()) {
                AttributeField a;
                String n;
                Object o = this.attributesList.elementAt(i);
                if (o instanceof AttributeField && (n = (a = (AttributeField)o).getName()) != null && name.equals(n)) {
                    a.setValue(value);
                    return;
                }
                ++i;
            }
            AttributeField af = new AttributeField();
            af.setName(name);
            af.setValue(value);
            this.attributesList.addElement(af);
        }
    }

    public void setAttributes(Vector attributes) throws SdpException {
        if (attributes == null) {
            throw new SdpException("The parameter is null");
        }
        this.attributesList = attributes;
    }

    public Vector getMediaDescriptions(boolean create) throws SdpException {
        if (this.mediaDescriptions == null && create) {
            this.mediaDescriptions = new Vector();
        }
        return this.mediaDescriptions;
    }

    public void setMediaDescriptions(Vector mediaDescriptions) throws SdpException {
        if (mediaDescriptions == null) {
            throw new SdpException("The parameter is null");
        }
        this.mediaDescriptions = mediaDescriptions;
    }

    private String encodeVector(Vector vector) {
        StringBuffer encBuff = new StringBuffer();
        int i = 0;
        while (i < vector.size()) {
            encBuff.append(vector.elementAt(i));
            ++i;
        }
        return encBuff.toString();
    }

    private Vector cloneVector(Vector v) {
        Vector clone = new Vector(v.capacity());
        int size = v.size();
        int i = 0;
        while (i < size) {
            clone.setElementAt(v.elementAt(i), i);
            ++i;
        }
        return clone;
    }

    public String toString() {
        StringBuffer encBuff = new StringBuffer();
        encBuff.append(this.getVersion() == null ? "" : this.getVersion().toString());
        encBuff.append(this.getOrigin() == null ? "" : this.getOrigin().toString());
        encBuff.append(this.getSessionName() == null ? "" : this.getSessionName().toString());
        encBuff.append(this.getInfo() == null ? "" : this.getInfo().toString());
        try {
            encBuff.append(this.getURI() == null ? "" : this.getURI().toString());
            encBuff.append(this.encodeVector(this.getEmails(true)));
            encBuff.append(this.encodeVector(this.getPhones(true)));
            encBuff.append(this.getConnection() == null ? "" : this.getConnection().toString());
            encBuff.append(this.encodeVector(this.getBandwidths(true)));
            encBuff.append(this.encodeVector(this.getTimeDescriptions(true)));
            encBuff.append(this.encodeVector(this.getZoneAdjustments(true)));
            encBuff.append(this.getKey() == null ? "" : this.getKey().toString());
            encBuff.append(this.encodeVector(this.getAttributes(true)));
            encBuff.append(this.encodeVector(this.getMediaDescriptions(true)));
        }
        catch (SdpException sdpException) {
            // empty catch block
        }
        return encBuff.toString();
    }
}

