/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core;

import java.util.Vector;
import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.NameValue;

public class NameValueList
extends GenericObject {
    private Vector nvList = new Vector();
    private String separator = ";";

    public NameValueList(String listName) {
    }

    public Vector getNames() {
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < names.size()) {
            names.addElement(((NameValue)this.nvList.elementAt((int)i)).name);
            ++i;
        }
        return names;
    }

    public NameValue elementAt(int i) {
        if (i >= this.nvList.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds" + i);
        }
        return (NameValue)this.nvList.elementAt(i);
    }

    public void add(NameValue nv) {
        if (nv == null) {
            throw new NullPointerException("null nv");
        }
        this.nvList.addElement(nv);
    }

    public void set(NameValue nv) {
        this.delete(nv.name);
        this.add(nv);
    }

    public void set(String name, Object value) {
        NameValue nv = new NameValue(name, value);
        this.set(nv);
    }

    public void add(String name, Object obj) {
        if (name == null) {
            throw new NullPointerException("name in null ! ");
        }
        NameValue nv = new NameValue(name, obj);
        this.add(nv);
    }

    public boolean equals(Object otherObject) {
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        NameValueList other = (NameValueList)otherObject;
        if (this.nvList.size() != other.nvList.size()) {
            return false;
        }
        int i = 0;
        while (i < this.nvList.size()) {
            NameValue nv = (NameValue)this.nvList.elementAt(i);
            NameValue nv1 = other.getNameValue(nv.name);
            if (nv1 == null) {
                return false;
            }
            if (!nv1.equals(nv)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object getValue(String name) {
        NameValue nv = this.getNameValue(name);
        if (nv != null) {
            return nv.value;
        }
        return null;
    }

    public NameValue getNameValue(String name) {
        if (name == null) {
            throw new NullPointerException("null arg!");
        }
        String name1 = name.toLowerCase();
        int i = 0;
        while (i < this.nvList.size()) {
            NameValue nv = (NameValue)this.nvList.elementAt(i);
            if (nv.getName() != null && nv.getName().toLowerCase().equals(name1)) {
                return nv;
            }
            ++i;
        }
        return null;
    }

    public boolean hasNameValue(String name) {
        return this.getNameValue(name) != null;
    }

    public boolean delete(String name) {
        int i = 0;
        String name1 = name.toLowerCase();
        i = 0;
        while (i < this.nvList.size()) {
            NameValue nv = (NameValue)this.nvList.elementAt(i);
            if (nv.getName() != null && nv.getName().toLowerCase().equals(name1)) break;
            ++i;
        }
        if (i < this.nvList.size()) {
            this.nvList.removeElementAt(i);
        }
        return true;
    }

    public NameValueList() {
    }

    public Object clone() {
        NameValueList retval = new NameValueList();
        retval.separator = this.separator;
        int i = 0;
        while (i < this.nvList.size()) {
            NameValue nv = (NameValue)this.nvList.elementAt(i);
            NameValue nnv = (NameValue)nv.clone();
            retval.add(nnv);
            ++i;
        }
        return retval;
    }

    public String getParameter(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    public Object first() {
        return this.nvList.elementAt(0);
    }

    public String encode() {
        if (this.nvList.size() == 0) {
            return "";
        }
        StringBuffer encoding = new StringBuffer();
        int i = 0;
        while (i < this.nvList.size()) {
            Object obj = this.nvList.elementAt(i);
            if (obj instanceof GenericObject) {
                GenericObject gobj = (GenericObject)obj;
                encoding.append(gobj.encode());
            } else {
                encoding.append(obj.toString());
            }
            if (i >= this.nvList.size() - 1) break;
            encoding.append(this.separator);
            ++i;
        }
        return encoding.toString();
    }

    public String toString() {
        return this.encode();
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isEmpty() {
        return this.nvList.size() == 0;
    }

    public int size() {
        return this.nvList.size();
    }
}

