/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import org.linphone.jortp.PayloadType;

class PayloadTypeImpl
implements PayloadType {
    private String mMimeType;
    private int mClockRate;
    private int mChannels;
    private PayloadType.MediaType mType;
    private int mNumber;
    private String mRecvFmtp;
    private String mSendFmtp;

    PayloadTypeImpl(PayloadType.MediaType type, String mime, int clockrate, int chans) {
        this.mType = type;
        this.mMimeType = mime;
        this.mClockRate = clockrate;
        this.mChannels = chans;
    }

    public int getClockRate() {
        return this.mClockRate;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public int getNumChannels() {
        return this.mChannels;
    }

    public void setClockRate(int rate) {
        this.mClockRate = rate;
    }

    public void setMimeType(String mime) {
        this.mMimeType = mime;
    }

    public void setNumChannels(int nchans) {
        this.mChannels = nchans;
    }

    public void setType(PayloadType.MediaType mt) {
        this.mType = mt;
    }

    public PayloadType.MediaType getType() {
        return this.mType;
    }

    public static PayloadType createAudio(String mime, int clockrate) {
        return new PayloadTypeImpl(PayloadType.MediaType.Audio, mime, clockrate, 1);
    }

    public int getNumber() {
        return this.mNumber;
    }

    public void setNumber(int number) {
        this.mNumber = number;
    }

    public void appendRecvFmtp(String value) {
        if (this.mRecvFmtp == null) {
            this.mRecvFmtp = value;
        } else if (value != null) {
            this.mRecvFmtp = String.valueOf(this.mRecvFmtp) + value;
        }
    }

    public void appendSendFmtp(String value) {
        if (this.mSendFmtp == null) {
            this.mSendFmtp = value;
        } else if (value != null) {
            this.mSendFmtp = String.valueOf(this.mSendFmtp) + value;
        }
    }

    public String getRecvFmtp() {
        return this.mRecvFmtp;
    }

    public String getSendFmtp() {
        return this.mSendFmtp;
    }

    public void setRecvFmtp(String value) {
        this.mRecvFmtp = value;
    }

    public void setSendFmtp(String value) {
        this.mSendFmtp = value;
    }

    public PayloadType clone() {
        PayloadTypeImpl obj = new PayloadTypeImpl(this.mType, this.mMimeType, this.mClockRate, this.mChannels);
        obj.mRecvFmtp = this.mRecvFmtp;
        obj.mSendFmtp = this.mSendFmtp;
        return obj;
    }

    public boolean equals(PayloadType pt) {
        return this.mClockRate == pt.getClockRate() && this.mChannels == pt.getNumChannels() && this.mType == pt.getType() && this.mNumber == pt.getNumber() && this.mMimeType.equals(pt.getMimeType());
    }
}

