/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.sal.jsr180;

import java.io.IOException;
import org.linphone.jlinphone.sal.jsr180.SalOpImpl;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.jortp.SocketAddress;
import org.linphone.sal.Sal;
import org.linphone.sal.SalAddress;
import org.linphone.sal.SalException;
import org.linphone.sal.SalFactory;
import org.linphone.sal.SalListener;
import org.linphone.sal.SalOp;
import sip4me.gov.nist.core.Debug;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.microedition.sip.SipConnector;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.stack.ServerLog;
import sip4me.nist.javax.microedition.sip.SipClientConnection;
import sip4me.nist.javax.microedition.sip.SipConnectionNotifier;
import sip4me.nist.javax.microedition.sip.SipServerConnection;
import sip4me.nist.javax.microedition.sip.SipServerConnectionListener;

class SalImpl
implements Sal,
SipServerConnectionListener {
    private SipConnectionNotifier mConnectionNotifier;
    Logger mLog = JOrtpFactory.instance().createLogger("Sal");
    SipClientConnection mRegisterCnx;
    int mRegisterRefreshID;
    private SalListener mSalListener;
    private SalOp mIncallOp;
    private Sal.Transport mTransport;
    private String mPublicLocalAddress;
    private int mPublicLocalPort = -1;

    SalImpl() {
    }

    public void setIncallOp(SalOp anIncallOp) {
        this.mIncallOp = anIncallOp;
    }

    public void close() {
        if (this.mConnectionNotifier != null) {
            try {
                this.mConnectionNotifier.close();
            }
            catch (IOException e) {
                this.mLog.error("cannot close Sal connection", e);
            }
            this.mConnectionNotifier = null;
        }
    }

    public String getLocalAddr() throws SalException {
        try {
            if (this.mPublicLocalAddress != null) {
                return this.mPublicLocalAddress;
            }
            if (this.mConnectionNotifier != null) {
                return this.mConnectionNotifier.getLocalAddress();
            }
            throw new Exception("no notification listener");
        }
        catch (Throwable e) {
            throw new SalException("Cannot get Local address from notification listener", e);
        }
    }

    public int getLocalPort() throws SalException {
        try {
            if (this.mPublicLocalPort != -1) {
                return this.mPublicLocalPort;
            }
            if (this.mConnectionNotifier != null) {
                return this.mConnectionNotifier.getLocalPort();
            }
            throw new Exception("no notification listener");
        }
        catch (Throwable e) {
            throw new SalException("Cannot get Local port from notification listener", e);
        }
    }

    public void listenPort(SocketAddress addr, Sal.Transport t, boolean isSecure) throws SalException {
        try {
            Debug.enableDebug(false);
            LogWriter.needsLogging = true;
            ServerLog.setTraceLevel(ServerLog.TRACE_NONE);
            StackConnector.properties.setProperty("javax.sip.RETRANSMISSION_FILTER", "on");
            StackConnector.properties.setProperty("sip4me.gov.nist.javax.sip.NETWORK_LAYER", "sip4me.gov.nist.core.net.BBNetworkLayer");
            StackConnector.properties.setProperty("javax.sip.IP_ADDRESS", addr.getHost());
            this.mLog.info("Stack initialized with IP: " + addr.getHost());
            String SipConnectorUri = "sip:";
            SipConnectorUri = String.valueOf(SipConnectorUri) + addr.getPort();
            this.mTransport = t;
            if (t == Sal.Transport.Stream) {
                SipConnectorUri = String.valueOf(SipConnectorUri) + ";transport=tcp";
            }
            this.mConnectionNotifier = (SipConnectionNotifier)SipConnector.open(SipConnectorUri);
            this.mConnectionNotifier.setListener(this);
            System.out.println("SipConnectionNotifier opened at: " + this.mConnectionNotifier.getLocalAddress() + ":" + this.mConnectionNotifier.getLocalPort());
        }
        catch (Exception e) {
            throw new SalException("Cannot listen port for [" + addr + "] reason [" + e.getMessage() + "]", e);
        }
    }

    public void setListener(SalListener listener) {
        this.mSalListener = listener;
    }

    public void setUserAgent(String ua) {
    }

    public void setPublicLocalAddress(String aPublicLocalAddress) {
        this.mPublicLocalAddress = aPublicLocalAddress;
    }

    public void setPublicLocalPort(int aPublicLocalPort) {
        this.mPublicLocalPort = aPublicLocalPort;
    }

    public void notifyRequest(SipConnectionNotifier ssc) {
        SipServerConnection lCnx = null;
        try {
            lCnx = ssc.acceptAndOpen();
            this.mLog.info("receiving request: " + lCnx.getMethod() + " " + lCnx.getRequestURI());
            if ("INVITE".equals(lCnx.getMethod())) {
                SalOpImpl lOp = new SalOpImpl(this, this.mConnectionNotifier, this.mSalListener, lCnx);
                SalAddress lFrom = SalFactory.instance().createSalAddress(lCnx.getHeader("From"));
                SalAddress lTo = SalFactory.instance().createSalAddress(lCnx.getHeader("To"));
                lOp.setFrom(lFrom.asStringUriOnly());
                lOp.setTo(lTo.asStringUriOnly());
                lCnx.initResponse(100);
                lCnx.send();
                this.mIncallOp = lOp;
                this.mSalListener.onCallReceived(lOp);
            } else if (this.mIncallOp != null) {
                ((SalOpImpl)this.mIncallOp).notifyRequestReceived(lCnx);
            } else {
                lCnx.initResponse(500);
                lCnx.send();
            }
        }
        catch (Throwable e) {
            if (lCnx != null) {
                this.mLog.error("Cannot answer to : " + lCnx.getMethod() + " " + lCnx.getRequestURI(), e);
            }
            this.mLog.error("Unknown error while processing Request", e);
        }
    }

    public SalOp createSalOp() {
        return new SalOpImpl(this, this.mConnectionNotifier, this.mSalListener);
    }

    public Sal.Transport getTransport() {
        return this.mTransport;
    }
}

