/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.sal.jsr180;

import org.linphone.sal.Sal;
import org.linphone.sal.SalAddress;
import sip4me.nist.javax.microedition.sip.SipAddress;

class SalAddressImpl
implements SalAddress {
    final SipAddress mAddress;

    SalAddressImpl(String address) {
        this.mAddress = new SipAddress(address);
    }

    public String asString() {
        return this.mAddress.toString();
    }

    public String asStringUriOnly() {
        return this.mAddress.getURI();
    }

    public void clean() {
        throw new RuntimeException("Not implemented");
    }

    public String getDisplayName() {
        return this.mAddress.getDisplayName();
    }

    public String getDomain() {
        return this.mAddress.getHost();
    }

    public String getPort() {
        return String.valueOf(this.getPortInt());
    }

    public int getPortInt() {
        int lPort = this.mAddress.getPort();
        if (lPort > 0) {
            return lPort;
        }
        return -1;
    }

    public String getUserName() {
        return this.mAddress.getUser();
    }

    public void setDisplayName(String displayName) {
        this.mAddress.setDisplayName(displayName);
    }

    public void setDomain(String domain) {
        this.mAddress.setHost(domain);
    }

    public void setPort(String port) {
        this.setPortInt(Integer.parseInt(port));
    }

    public void setPortInt(int port) {
        this.mAddress.setPort(port);
    }

    public void setUserName(String username) {
        this.mAddress.setUser(username);
    }

    public String toString() {
        return this.asString();
    }

    public Sal.Transport getTransport() {
        String lTransport = this.mAddress.getParameter("transport");
        if (lTransport != null) {
            if (lTransport.equalsIgnoreCase("tcp")) {
                return Sal.Transport.Stream;
            }
            if (lTransport.equalsIgnoreCase("udp")) {
                return Sal.Transport.Datagram;
            }
        }
        return null;
    }

    public void setTransport(Sal.Transport aTransport) {
        if (aTransport == Sal.Transport.Stream) {
            this.mAddress.setParameter("transport", "tcp");
        }
    }
}

