# ZComment style definition
Style ZComment
  Margin		Dynamic
  LatexType		Command
  LatexName		zcomment
  NextNoIndent		1
  LeftMargin		MMM
  RightMargin           MMM
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelSep		:x
  Labelstring		"Comment:"

  LabelFont
	Shape		Italic
	Series		Bold
	Color		black
  EndFont

  TextFont
	Color		blue
	Shape		Italic
  EndFont

  Preamble
  \newcommand{\eat}[1]{#1}
  \newcommand{\zcomment}[1]{
	  \eat{
		  {\bf Comment:} #1
	  }
  }
  EndPreamble
End

Style Definition
  Margin		First_Dynamic
  LatexType		Environment
  LatexName		definition
  NextNoIndent		1
  LabelSep		xx
  ParIndent             MMM  
  ParSkip		0.4
  ItemSep		0.2
  TopSep		0.7
  BottomSep		0.7
  ParSep		0.3
  Align			Block
  AlignPossible		Block, Left
  LabelType		Static
  LabelString		"Definition"

  # standard font definition
  Font
    Shape 		Italic
    Size		Normal
  EndFont

  # label font definition
  LabelFont
    Shape		Up
    Series		Bold
  EndFont

  Preamble
    \newtheorem{definition}{Definition} 
  EndPreamble

End  