""" S E B U B L A  S H A D E R
Model:		BgDM
Textures:	TorQ
Demonstrates blending a samplers with vertex color as well as
per-pixel lighting from two light sources.
"""

import GameLogic as g
objlist = g.getCurrentScene().getObjectList()

# -------------------------------------
ShaderObjects = [
	objlist['OBSeb'],
	objlist['OBEye1'],
	objlist['OBEye2']
	]

MaterialIndexList = [0] # only one on sebulba and eyes
GlobalAmbient = [0.39,0.35,0.32,1]
AmbF = 1.0

# -------------------------------------


# -------------------------------------
VertexShader = """
varying vec2 texcoords;
varying vec3 lvec[2];
varying vec3 view_vector;
varying vec3 normal;
varying vec4 vcol;

void main() {
	vec3 vert = (gl_ModelViewMatrix * gl_Vertex).xyz;	
	lvec[0]= (gl_LightSource[0].position).xyz - vert;
	lvec[1]= (gl_LightSource[1].position).xyz - vert;

	normal = gl_NormalMatrix *gl_Normal;
	view_vector = (vert);

	vcol = gl_Color;
	
	texcoords = gl_MultiTexCoord0.st;
	gl_Position = ftransform();
}
"""

FragmentShader = """
const float AmbF = %f;
const vec4 AmbG = vec4(%f,%f,%f,%f);

uniform sampler2D color;

varying vec3 lvec[2];
varying vec2 texcoords;
varying vec3 view_vector;
varying vec3 normal;
varying vec4 vcol;

void main() {
	vec3 l,v,n;
	vec4 diff0, diff1,amb;
	float diffuse0, diffuse1;
	float spec0, spec1;

	vec4 texture = texture2D(color,texcoords);

	// ambient color * factor	
	amb= AmbG*AmbF;
	
	const float specular_power = 100.0; // > sharp spec

	// lighting ...  
		
	// light 1		
	n= normalize(normal);
	v= normalize(view_vector);
	l = normalize(lvec[0]);
	diffuse0 = max(dot(l,n), 0.0);
	diff0 = gl_LightSource[0].diffuse;	// lamp color in blender menu
	spec0 = pow(max(dot(reflect(v, n), l),0.0),specular_power);
	
	// light 2		
	n= normalize(normal);
	v= normalize(view_vector);
	l = normalize(lvec[1]);	
	diffuse1 = max(dot(l,n), 0.0);
	diff1 = gl_LightSource[1].diffuse;	// lamp color in blender menu
	spec1 = pow(max(dot(reflect(v, n), l),0.0),specular_power);

	
	// (texture * vertexcolor)+ ( ambient color + light1 + light2 ) - 0.5
	
	texture *= vcol;
	gl_FragColor = texture+((amb) + (diffuse0*diff0+spec0*diff1) + (diffuse1*diff1+spec1*diff1))-0.5;
}
""" %\
(AmbF,GlobalAmbient[0],GlobalAmbient[1],GlobalAmbient[2],GlobalAmbient[3])


def MainLoop ():
	# for each object
	for obj in ShaderObjects:

		mesh_index = 0
		mesh = obj.getMesh(mesh_index)

		while mesh != None:

			for mat in mesh.materials:
				
				# regular TexFace materials do NOT have this function
				if not hasattr(mat, "getMaterialIndex"):
					return
				
				mat_index = mat.getMaterialIndex()

				# find an index				
				found = 0
				for i in range(len(MaterialIndexList)):
					if mat_index == MaterialIndexList[i]:
						found=1
						break
				if not found: continue

				shader = mat.getShader()
				if not shader.isValid():

					shader.setSource(VertexShader, FragmentShader,1)
					shader.setNumberOfPasses(1)

				# set uniforms					
				shader.setSampler('color', 0)

			mesh_index += 1
			mesh = obj.getMesh(mesh_index)


# -------------------------------------
MainLoop()
# -------------------------------------