/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.route;

import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.router.api.ExportConfiguration;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.apache.unomi.router.core.bean.CollectProfileBean;
import org.apache.unomi.router.core.route.RouterAbstractRouteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileExportCollectRouteBuilder
extends RouterAbstractRouteBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ProfileExportCollectRouteBuilder.class);
    private List<ExportConfiguration> exportConfigurationList;
    private ImportExportConfigurationService<ExportConfiguration> exportConfigurationService;
    private PersistenceService persistenceService;

    public ProfileExportCollectRouteBuilder(Map<String, String> kafkaProps, String configType) {
        super(kafkaProps, configType);
    }

    public void configure() throws Exception {
        logger.info("Configure Recurrent Route 'Export :: Collect Data'");
        if (this.exportConfigurationList == null) {
            this.exportConfigurationList = this.exportConfigurationService.getAll();
        }
        CollectProfileBean collectProfileBean = new CollectProfileBean();
        collectProfileBean.setPersistenceService(this.persistenceService);
        for (ExportConfiguration exportConfiguration : this.exportConfigurationList) {
            if ("recurrent".equals(exportConfiguration.getConfigType()) && exportConfiguration.getProperties() != null && exportConfiguration.getProperties().size() > 0) {
                if ((Map)exportConfiguration.getProperties().get("mapping") != null) {
                    String destinationEndpoint = (String)exportConfiguration.getProperties().get("destination");
                    if (StringUtils.isNotBlank((CharSequence)destinationEndpoint) && this.allowedEndpoints.contains(destinationEndpoint.substring(0, destinationEndpoint.indexOf(58)))) {
                        String timerString = "timer://collectProfile?fixedRate=true&period=" + (String)exportConfiguration.getProperties().get("period");
                        if ((String)exportConfiguration.getProperties().get("delay") != null) {
                            timerString = timerString + "&delay=" + (String)exportConfiguration.getProperties().get("delay");
                        }
                        ProcessorDefinition prDef = ((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from(timerString).routeId(exportConfiguration.getItemId()).autoStartup(exportConfiguration.isActive()).bean((Object)collectProfileBean, "extractProfileBySegment(" + exportConfiguration.getProperties().get("segment") + ")")).split((Expression)this.body()).marshal((DataFormat)this.jacksonDataFormat)).convertBodyTo(String.class)).setHeader("exportConfig", (Expression)this.constant(exportConfiguration))).log(LoggingLevel.DEBUG, "BODY : ${body}");
                        if ("kafka".equals(this.configType)) {
                            prDef.to((Endpoint)((KafkaEndpoint)this.getEndpointURI("from", "direct:depositExportBuffer")));
                            continue;
                        }
                        prDef.to((String)this.getEndpointURI("from", "direct:depositExportBuffer"));
                        continue;
                    }
                    logger.error("Endpoint scheme {} is not allowed, route {} will be skipped.", (Object)destinationEndpoint.substring(0, destinationEndpoint.indexOf(58)), (Object)exportConfiguration.getItemId());
                    continue;
                }
                logger.warn("Mapping is null in export configuration, route {} will be skipped!", (Object)exportConfiguration.getItemId());
                continue;
            }
            logger.warn("Export configuration incomplete, route {} will be skipped!", (Object)exportConfiguration.getItemId());
        }
    }

    public void setExportConfigurationList(List<ExportConfiguration> exportConfigurationList) {
        this.exportConfigurationList = exportConfigurationList;
    }

    public void setExportConfigurationService(ImportExportConfigurationService<ExportConfiguration> exportConfigurationService) {
        this.exportConfigurationService = exportConfigurationService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

