/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.List;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilderDispatcher;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanConditionESQueryBuilder
implements ConditionESQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger((String)BooleanConditionESQueryBuilder.class.getName());

    public QueryBuilder buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        boolean isAndOperator = "and".equalsIgnoreCase((String)condition.getParameter("operator"));
        List conditions = (List)condition.getParameter("subConditions");
        int conditionCount = conditions.size();
        if (conditionCount == 1) {
            return dispatcher.buildFilter((Condition)conditions.get(0), context);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (int i = 0; i < conditionCount; ++i) {
            if (isAndOperator) {
                QueryBuilder andFilter = dispatcher.buildFilter((Condition)conditions.get(i), context);
                if (andFilter != null) {
                    if (andFilter.getName().equals("range")) {
                        boolQueryBuilder.filter(andFilter);
                        continue;
                    }
                    boolQueryBuilder.must(andFilter);
                    continue;
                }
                logger.warn("Null filter for boolean AND sub condition " + conditions.get(i));
                continue;
            }
            QueryBuilder orFilter = dispatcher.buildFilter((Condition)conditions.get(i), context);
            if (orFilter != null) {
                if (orFilter.getName().equals("range")) {
                    boolQueryBuilder.filter(orFilter);
                    continue;
                }
                boolQueryBuilder.should(orFilter);
                continue;
            }
            logger.warn("Null filter for boolean OR sub condition " + conditions.get(i));
        }
        return boolQueryBuilder;
    }
}

