/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import java.util.Arrays;
import org.apache.felix.metatype.internal.BaseProviderHolder;
import org.apache.felix.metatype.internal.MetaTypeServiceImpl;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.MetaTypeProvider;

class MetaTypeProviderHolder
extends BaseProviderHolder {
    private String[] pids;
    private String[] factoryPids;

    MetaTypeProviderHolder(ServiceReference reference, MetaTypeProvider provider) {
        super(reference, provider);
        this.pids = BaseProviderHolder.getStringPlus(reference, "metatype.pid");
        this.factoryPids = BaseProviderHolder.getStringPlus(reference, "metatype.factory.pid");
    }

    String[] getPids() {
        return this.pids;
    }

    String[] getFactoryPids() {
        return this.factoryPids;
    }

    void update(MetaTypeServiceImpl mti) {
        Object[] pids = BaseProviderHolder.getStringPlus(this.getReference(), "metatype.pid");
        Object[] factoryPids = BaseProviderHolder.getStringPlus(this.getReference(), "metatype.factory.pid");
        if (!Arrays.equals(pids, this.pids) || !Arrays.equals(factoryPids, this.factoryPids)) {
            mti.removeService(this);
            this.pids = pids;
            this.factoryPids = factoryPids;
            mti.addService(this);
        }
    }
}

