/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.logging;

import org.apache.commons.jcs.engine.logging.CacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheEventLoggerDebugLogger
implements ICacheEventLogger {
    private String logCategoryName = CacheEventLoggerDebugLogger.class.getName();
    private Log log = LogFactory.getLog((String)this.logCategoryName);

    @Override
    public <T> ICacheEvent<T> createICacheEvent(String source, String region, String eventName, String optionalDetails, T key) {
        CacheEvent<T> event = new CacheEvent<T>();
        event.setSource(source);
        event.setRegion(region);
        event.setEventName(eventName);
        event.setOptionalDetails(optionalDetails);
        event.setKey(key);
        return event;
    }

    @Override
    public void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(source + " | " + eventName + " | " + optionalDetails));
        }
    }

    @Override
    public void logError(String source, String eventName, String errorMessage) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(source + " | " + eventName + " | " + errorMessage));
        }
    }

    @Override
    public <T> void logICacheEvent(ICacheEvent<T> event) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(event);
        }
    }

    public synchronized void setLogCategoryName(String logCategoryName) {
        if (logCategoryName != null && !logCategoryName.equals(this.logCategoryName)) {
            this.logCategoryName = logCategoryName;
            this.log = LogFactory.getLog((String)logCategoryName);
        }
    }
}

