/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.coverage.Category;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.netcdf.base.DataType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Linearizer;
import org.apache.sis.storage.netcdf.base.Node;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.base.VariableRole;
import org.apache.sis.system.Reflect;
import org.apache.sis.util.Numbers;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Convention {
    private static final ServiceLoader<Convention> AVAILABLES = ServiceLoader.load(Convention.class, Reflect.getContextClassLoader());
    public static final Convention DEFAULT = new Convention();
    private static final String[] SEARCH_PATH = new String[]{"NCISOMetadata", "CFMetadata", null, "THREDDSMetadata"};
    private static final String[] RANGE_ATTRIBUTES = new String[]{"valid_range", "actual_range", "valid_min", "valid_max"};
    private static final String[] NODATA_ATTRIBUTES = new String[]{"_FillValue", "missing_value"};
    protected static final int FILL_VALUE_MASK = 1;
    protected static final int MISSING_VALUE_MASK = 2;
    protected static final String LONGITUDE_OF_PRIME_MERIDIAN = "longitude_of_prime_meridian";
    static final String NAME_SUFFIX = "_name";
    protected static final String ELLIPSOID_NAME = "reference_ellipsoid_name";
    protected static final String PRIME_MERIDIAN_NAME = "prime_meridian_name";
    protected static final String GEODETIC_DATUM_NAME = "horizontal_datum_name";
    protected static final String GEOGRAPHIC_CRS_NAME = "geographic_crs_name";
    protected static final String PROJECTED_CRS_NAME = "projected_crs_name";
    protected static final String CONVERSION_NAME = "conversion_name";
    protected static final String TOWGS84 = "towgs84";

    protected Convention() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Convention find(Decoder decoder) {
        Convention c;
        Iterator<Convention> it;
        ServiceLoader<Convention> serviceLoader = AVAILABLES;
        synchronized (serviceLoader) {
            it = AVAILABLES.iterator();
            if (!it.hasNext()) {
                return DEFAULT;
            }
            c = it.next();
        }
        while (!c.isApplicableTo(decoder)) {
            serviceLoader = AVAILABLES;
            synchronized (serviceLoader) {
                if (!it.hasNext()) {
                    c = DEFAULT;
                    break;
                }
                c = it.next();
            }
        }
        return c;
    }

    protected boolean isApplicableTo(Decoder decoder) {
        return false;
    }

    public String[] getSearchPath() {
        return (String[])SEARCH_PATH.clone();
    }

    public String mapAttributeName(String name, int index) {
        return index == 0 ? name : null;
    }

    public VariableRole roleOf(Variable variable) {
        if (variable.isCoordinateSystemAxis()) {
            return VariableRole.AXIS;
        }
        int n = variable.getNumDimensions();
        if (n == 1) {
            return VariableRole.FEATURE_PROPERTY;
        }
        if (n != 0) {
            DataType dataType = variable.getDataType();
            int numVectors = 0;
            for (Dimension dimension : variable.getGridDimensions()) {
                if (dimension.length() < 2L) continue;
                ++numVectors;
            }
            if (numVectors >= 2 && dataType.rasterDataType != null) {
                return VariableRole.COVERAGE;
            }
            if (n == 2 && dataType == DataType.CHAR) {
                return VariableRole.FEATURE_PROPERTY;
            }
        }
        return VariableRole.OTHER;
    }

    public String[] namesOfAxisVariables(Variable data) {
        return null;
    }

    public String nameOfDimension(Variable dataOrAxis, int index) {
        return dataOrAxis.getAttributeAsString("dim" + index);
    }

    public double gridToDataIndices(Variable axis) {
        return axis.getAttributeAsDouble("resampling_interval");
    }

    public Set<Linearizer> linearizers(Decoder decoder) {
        return Set.of();
    }

    public Set<String> nameOfMappingNode(Variable data) {
        String mapping = data.getAttributeAsString("grid_mapping");
        return mapping != null ? Set.of(mapping) : Set.of();
    }

    public Map<String, Object> projection(Node node) {
        String method = node.getAttributeAsString("grid_mapping_name");
        if (method == null) {
            return null;
        }
        HashMap<String, Object> definition = new HashMap<String, Object>();
        definition.put("grid_mapping_name", method);
        block12: for (String name : node.getAttributeNames()) {
            try {
                Object value;
                String ln;
                switch (ln = name.toLowerCase(Locale.US)) {
                    case "grid_mapping_name": {
                        continue block12;
                    }
                    case "towgs84": {
                        Vector values = node.getAttributeAsVector(name);
                        if (values == null || values.size() < 3) continue block12;
                        BursaWolfParameters bp = new BursaWolfParameters(CommonCRS.WGS84.datum(), null);
                        bp.setValues(values.doubleValues());
                        value = bp;
                        break;
                    }
                    case "crs_wkt": {
                        continue block12;
                    }
                    default: {
                        if (ln.endsWith(NAME_SUFFIX) && (value = node.getAttributeAsString(name)) == null || (value = node.getAttributeValue(name)) == null) continue block12;
                        if (!(value instanceof Vector)) break;
                        value = ((Vector)value).doubleValues();
                    }
                }
                if (definition.putIfAbsent(name, value) == null) continue;
                node.error(Convention.class, "projection", null, (short)25, name);
            }
            catch (NumberFormatException e) {
                node.decoder.illegalAttributeValue(name, node.getAttributeAsString(name), e);
            }
        }
        return definition;
    }

    public MathTransform gridToCRS(Node node, MathTransform baseToCRS) throws TransformException {
        return null;
    }

    public CommonCRS defaultHorizontalCRS(boolean spherical) {
        return spherical ? CommonCRS.SPHERE : CommonCRS.GRS1980;
    }

    public NumberRange<?> validRange(Variable data) {
        Number minimum = null;
        Number maximum = null;
        Class<? extends Number> type = null;
        for (String attribute : RANGE_ATTRIBUTES) {
            Vector values = data.getAttributeAsVector(attribute);
            if (values != null) {
                int length = values.size();
                for (int i = 0; i < length; ++i) {
                    try {
                        Number value = values.get(i);
                        if (value instanceof Float) {
                            float fp = ((Float)value).floatValue();
                            if (fp == Float.MAX_VALUE) {
                                value = Float.valueOf(Float.POSITIVE_INFINITY);
                            } else if (fp == -3.4028235E38f) {
                                value = Float.valueOf(Float.NEGATIVE_INFINITY);
                            }
                        } else if (value instanceof Double) {
                            double fp = (Double)value;
                            if (fp == Double.MAX_VALUE) {
                                value = Double.POSITIVE_INFINITY;
                            } else if (fp == -1.7976931348623157E308) {
                                value = Double.NEGATIVE_INFINITY;
                            }
                        }
                        type = Numbers.widestClass(type, value.getClass());
                        minimum = Numbers.cast(minimum, type);
                        maximum = Numbers.cast(maximum, type);
                        value = Numbers.cast(value, type);
                        if (!(attribute.endsWith("max") || minimum != null && Convention.compare(value, minimum) >= 0)) {
                            minimum = value;
                        }
                        if (attribute.endsWith("min") || maximum != null && Convention.compare(value, maximum) <= 0) continue;
                        maximum = value;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        data.decoder.illegalAttributeValue(attribute, values.stringValue(i), e);
                    }
                }
            }
            if (minimum == null || maximum == null) continue;
            Class<?> scaleType = data.getAttributeType("scale_factor");
            Class<?> offsetType = data.getAttributeType("add_offset");
            byte rangeType = Numbers.getEnumConstant(type);
            if ((scaleType != null || offsetType != null) && rangeType >= data.getDataType().number && rangeType >= Math.max(Numbers.getEnumConstant(scaleType), Numbers.getEnumConstant(offsetType))) {
                MeasurementRange<Number> range = new MeasurementRange<Number>(type, minimum, true, maximum, true, data.getUnit());
                return range;
            }
            boolean isMinIncluded = true;
            boolean isMaxIncluded = true;
            Set<Number> nodataValues = data.getNodataValues().keySet();
            if (!nodataValues.isEmpty()) {
                double minValue = minimum.doubleValue();
                double maxValue = maximum.doubleValue();
                for (Number pad : nodataValues) {
                    double value = pad.doubleValue();
                    isMinIncluded &= minValue != value;
                    isMaxIncluded &= maxValue != value;
                }
            }
            NumberRange<Number> range = new NumberRange<Number>(type, minimum, isMinIncluded, maximum, isMaxIncluded);
            return range;
        }
        return null;
    }

    private static int compare(Number n1, Number n2) {
        return ((Comparable)((Object)n1)).compareTo((Comparable)((Object)n2));
    }

    public Map<Number, Object> nodataValues(Variable data) {
        LinkedHashMap<Number, Object> pads = new LinkedHashMap<Number, Object>();
        for (int i = 0; i < NODATA_ATTRIBUTES.length; ++i) {
            String name = NODATA_ATTRIBUTES[i];
            Vector values = data.getAttributeAsVector(name);
            if (values == null) continue;
            int length = values.size();
            for (int j = 0; j < length; ++j) {
                try {
                    pads.merge(values.get(j), 1 << i, (v1, v2) -> (Integer)v1 | (Integer)v2);
                    continue;
                }
                catch (NumberFormatException e) {
                    data.decoder.illegalAttributeValue(name, values.stringValue(i), e);
                }
            }
        }
        return pads;
    }

    public TransferFunction transferFunction(Variable data) {
        TransferFunction tr = new TransferFunction();
        double scale = data.getAttributeAsDouble("scale_factor");
        double offset = data.getAttributeAsDouble("add_offset");
        if (!Double.isNaN(scale)) {
            tr.setScale(scale);
        }
        if (!Double.isNaN(offset)) {
            tr.setOffset(offset);
        }
        return tr;
    }

    public Unit<?> getUnitFallback(Variable data) throws MeasurementParseException {
        return null;
    }

    public int getVisibleBand() {
        return 0;
    }

    public Function<Category, Color[]> getColors(Variable data) {
        return null;
    }
}

