/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ner.opennlp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.parser.ner.NERecogniser;
import org.apache.tika.parser.ner.opennlp.OpenNLPNameFinder;

public class OpenNLPNERecogniser
implements NERecogniser {
    public static final String MODELS_DIR = OpenNLPNERecogniser.class.getPackage().getName().replace(".", "/");
    public static final String PERSON_FILE = "ner-person.bin";
    public static final String LOCATION_FILE = "ner-location.bin";
    public static final String ORGANIZATION_FILE = "ner-organization.bin";
    public static final String TIME_FILE = "ner-time.bin";
    public static final String DATE_FILE = "ner-date.bin";
    public static final String PERCENT_FILE = "ner-percentage.bin";
    public static final String MONEY_FILE = "ner-money.bin";
    public static final String NER_PERSON_MODEL = MODELS_DIR + "/ner-person.bin";
    public static final String NER_LOCATION_MODEL = MODELS_DIR + "/ner-location.bin";
    public static final String NER_ORGANIZATION_MODEL = MODELS_DIR + "/ner-organization.bin";
    public static final String NER_TIME_MODEL = MODELS_DIR + "/ner-time.bin";
    public static final String NER_DATE_MODEL = MODELS_DIR + "/ner-date.bin";
    public static final String NER_PERCENT_MODEL = MODELS_DIR + "/ner-percentage.bin";
    public static final String NER_MONEY_MODEL = MODELS_DIR + "/ner-money.bin";
    public static final Map<String, String> DEFAULT_MODELS = new HashMap<String, String>(){
        {
            this.put("PERSON", NER_PERSON_MODEL);
            this.put("LOCATION", NER_LOCATION_MODEL);
            this.put("ORGANIZATION", NER_ORGANIZATION_MODEL);
            this.put("TIME", NER_TIME_MODEL);
            this.put("DATE", NER_DATE_MODEL);
            this.put("PERCENT", NER_PERCENT_MODEL);
            this.put("MONEY", NER_MONEY_MODEL);
        }
    };
    private Set<String> entityTypes;
    private List<OpenNLPNameFinder> nameFinders = new ArrayList<OpenNLPNameFinder>();
    private boolean available;

    public OpenNLPNERecogniser() {
        this(DEFAULT_MODELS);
    }

    public OpenNLPNERecogniser(Map<String, String> models) {
        this.entityTypes = new HashSet<String>();
        for (Map.Entry<String, String> entry : models.entrySet()) {
            OpenNLPNameFinder finder = new OpenNLPNameFinder(entry.getKey(), entry.getValue());
            if (!finder.isAvailable()) continue;
            this.nameFinders.add(finder);
            this.entityTypes.add(entry.getKey());
        }
        this.entityTypes = Collections.unmodifiableSet(this.entityTypes);
        this.available = this.nameFinders.size() > 0;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public Set<String> getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    public Map<String, Set<String>> recognise(String text) {
        String[] tokens = OpenNLPNameFinder.tokenize(text);
        HashMap<String, Set<String>> names = new HashMap<String, Set<String>>();
        for (OpenNLPNameFinder finder : this.nameFinders) {
            names.putAll(finder.findNames(tokens));
        }
        return names;
    }
}

