/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.extensions.connectors.influx.shared;

public class InfluxKeys {

  public static final String DATABASE_PROTOCOL = "db_protocol";
  public static final String DATABASE_HOST_KEY = "db_host";
  public static final String DATABASE_PORT_KEY = "db_port";
  public static final String DATABASE_NAME_KEY = "db_name";
  public static final String DATABASE_MEASUREMENT_KEY = "db_measurement";
  public static final String DATABASE_USER_KEY = "db_user";
  public static final String DATABASE_PASSWORD_KEY = "db_password";
  public static final String TIMESTAMP_MAPPING_KEY = "timestamp_mapping";
  public static final String BATCH_INTERVAL_ACTIONS_KEY = "batch_interval_actions";
  public static final String MAX_FLUSH_DURATION_KEY = "max_flush_duration";
  public static final String DATABASE_AUTHENTICATION = "db_authentication";
  public static final String DATABASE_TOKEN_KEY = "db_token";
  public static final String USERNAME_PASSWORD_ALT = "db_username_alt";
  public static final String USERNAME_GROUP_KEY = "db_username_group";
  public static final String DATABASE_TOKEN_ALT = "db_token_alt";
}
