/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class BoundedByteBufferPool {
    private final Log LOG = LogFactory.getLog(this.getClass());
    @VisibleForTesting
    final Queue<ByteBuffer> buffers;
    private final int maxByteBufferSizeToCache;
    private volatile int runningAverage;
    private volatile int totalReservoirCapacity;
    private AtomicLong allocations = new AtomicLong(0L);

    public BoundedByteBufferPool(int maxByteBufferSizeToCache, int initialByteBufferSize, int maxToCache) {
        this.maxByteBufferSizeToCache = maxByteBufferSizeToCache;
        this.runningAverage = initialByteBufferSize;
        this.buffers = new ArrayBlockingQueue<ByteBuffer>(maxToCache, true);
    }

    public ByteBuffer getBuffer() {
        ByteBuffer bb = this.buffers.poll();
        if (bb != null) {
            bb.clear();
            this.totalReservoirCapacity -= bb.capacity();
        } else {
            bb = ByteBuffer.allocate(this.runningAverage);
            this.allocations.incrementAndGet();
        }
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("runningAverage=" + this.runningAverage + ", totalCapacity=" + this.totalReservoirCapacity + ", count=" + this.buffers.size() + ", alloctions=" + this.allocations.get()));
        }
        return bb;
    }

    public void putBuffer(ByteBuffer bb) {
        if (bb.capacity() > this.maxByteBufferSizeToCache) {
            return;
        }
        if (!this.buffers.offer(bb)) {
            this.LOG.warn((Object)("At capacity: " + this.buffers.size()));
        } else {
            int size = this.buffers.size();
            this.totalReservoirCapacity += bb.capacity();
            int average = 0;
            if (size != 0) {
                average = this.totalReservoirCapacity / size;
            }
            if (average > this.runningAverage && average < this.maxByteBufferSizeToCache) {
                this.runningAverage = average;
            }
        }
    }
}

