/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.Util;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlImporter
implements ProtectedNodeImporter,
AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(AccessControlImporter.class);
    private static final int CHILD_STATUS_UNDEFINED = 0;
    private static final int CHILD_STATUS_ACE = 1;
    private static final int CHILD_STATUS_RESTRICTION = 2;
    private AccessControlManager acMgr;
    private PrincipalManager principalManager;
    private ReadOnlyNodeTypeManager ntMgr;
    private boolean initialized = false;
    private int childStatus;
    private JackrabbitAccessControlList acl;
    private MutableEntry entry;
    private int importBehavior;

    @Override
    public boolean init(@NotNull Session session, @NotNull Root root, @NotNull NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, @NotNull ReferenceChangeTracker referenceTracker, @NotNull SecurityProvider securityProvider) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (!(session instanceof JackrabbitSession)) {
            return false;
        }
        try {
            AuthorizationConfiguration config = securityProvider.getConfiguration(AuthorizationConfiguration.class);
            this.importBehavior = Util.getImportBehavior(config);
            if (isWorkspaceImport) {
                this.acMgr = config.getAccessControlManager(root, namePathMapper);
                PrincipalConfiguration pConfig = securityProvider.getConfiguration(PrincipalConfiguration.class);
                this.principalManager = pConfig.getPrincipalManager(root, namePathMapper);
            } else {
                this.acMgr = session.getAccessControlManager();
                this.principalManager = ((JackrabbitSession)session).getPrincipalManager();
            }
            this.ntMgr = ReadOnlyNodeTypeManager.getInstance(root, namePathMapper);
            this.initialized = true;
        }
        catch (RepositoryException e) {
            log.warn("Error while initializing access control importer", (Throwable)e);
        }
        return this.initialized;
    }

    @Override
    public void processReferences() {
    }

    @Override
    public boolean start(@NotNull Tree protectedParent) throws RepositoryException {
        this.checkInitialized();
        this.acl = this.getACL(protectedParent);
        return this.acl != null;
    }

    @Override
    public void end(@NotNull Tree protectedParent) throws RepositoryException {
        if (this.acl == null) {
            throw new IllegalStateException("End reached without ACL to write back.");
        }
        this.acMgr.setPolicy(this.acl.getPath(), (AccessControlPolicy)this.acl);
        this.acl = null;
    }

    @Override
    public void startChildInfo(@NotNull NodeInfo childInfo, @NotNull List<PropInfo> propInfos) throws RepositoryException {
        this.checkInitialized();
        String ntName = childInfo.getPrimaryTypeName();
        if ("rep:GrantACE".equals(ntName) || "rep:DenyACE".equals(ntName)) {
            if (this.entry != null) {
                throw new ConstraintViolationException("Invalid child node sequence: ACEs may not be nested.");
            }
            this.entry = new MutableEntry("rep:GrantACE".equals(ntName));
            for (PropInfo prop : propInfos) {
                String name = prop.getName();
                if ("rep:principalName".equals(name)) {
                    this.entry.setPrincipal(prop.getTextValue());
                    continue;
                }
                if ("rep:privileges".equals(name)) {
                    this.entry.setPrivilegeNames(prop.getTextValues());
                    continue;
                }
                this.entry.addRestriction(prop);
            }
            this.childStatus = 1;
        } else if ("rep:Restrictions".equals(ntName)) {
            if (this.entry == null) {
                throw new ConstraintViolationException("Invalid child node sequence: Restriction must be associated with an ACE");
            }
            this.entry.addRestrictions(propInfos);
            this.childStatus = 2;
        } else {
            throw new ConstraintViolationException("Invalid child node with type " + ntName);
        }
    }

    @Override
    public void endChildInfo() throws RepositoryException {
        this.checkInitialized();
        switch (this.childStatus) {
            case 1: {
                this.entry.applyTo(this.acl);
                this.entry = null;
                this.childStatus = 0;
                break;
            }
            case 2: {
                this.childStatus = 1;
                break;
            }
            default: {
                throw new ConstraintViolationException("Invalid child node sequence.");
            }
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    @Nullable
    private JackrabbitAccessControlList getACL(Tree tree) throws RepositoryException {
        String nodeName = tree.getName();
        JackrabbitAccessControlList acList = null;
        if (!tree.isRoot()) {
            Tree parent = tree.getParent();
            if ("rep:policy".equals(nodeName) && this.ntMgr.isNodeType(tree, "rep:ACL")) {
                String path = parent.getPath();
                acList = this.getACL(path);
            } else if ("rep:repoPolicy".equals(nodeName) && this.ntMgr.isNodeType(tree, "rep:ACL") && parent.isRoot()) {
                acList = this.getACL((String)null);
            }
        }
        if (acList != null) {
            for (AccessControlEntry ace : acList.getAccessControlEntries()) {
                acList.removeAccessControlEntry(ace);
            }
        }
        return acList;
    }

    @Nullable
    private JackrabbitAccessControlList getACL(@Nullable String path) throws RepositoryException {
        JackrabbitAccessControlList acList = null;
        for (AccessControlPolicy p : this.acMgr.getPolicies(path)) {
            if (!(p instanceof JackrabbitAccessControlList)) continue;
            acList = (JackrabbitAccessControlList)p;
            break;
        }
        return acList;
    }

    private final class MutableEntry {
        private final boolean isAllow;
        private Principal principal;
        private List<Privilege> privileges = new ArrayList<Privilege>();
        private Map<String, Value> restrictions = new HashMap<String, Value>();
        private Map<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();
        private boolean ignore;

        private MutableEntry(boolean isAllow) {
            this.isAllow = isAllow;
        }

        private void setPrincipal(TextValue txtValue) throws AccessControlException {
            String principalName = txtValue.getString();
            this.principal = AccessControlImporter.this.principalManager.getPrincipal(principalName);
            if (this.principal == null) {
                switch (AccessControlImporter.this.importBehavior) {
                    case 1: {
                        log.debug("Unknown principal {} -> Ignoring this ACE.", (Object)principalName);
                        this.ignore = true;
                        break;
                    }
                    case 2: {
                        this.principal = new PrincipalImpl(principalName);
                        break;
                    }
                    default: {
                        throw new AccessControlException("Unknown principal " + principalName);
                    }
                }
            }
        }

        private void setPrivilegeNames(List<? extends TextValue> txtValues) throws RepositoryException {
            for (TextValue textValue : txtValues) {
                Value privilegeName = textValue.getValue(7);
                this.privileges.add(AccessControlImporter.this.acMgr.privilegeFromName(privilegeName.getString()));
            }
        }

        private void addRestriction(PropInfo propInfo) throws RepositoryException {
            String restrictionName = propInfo.getName();
            int targetType = AccessControlImporter.this.acl.getRestrictionType(restrictionName);
            List<Value> values = propInfo.getValues(targetType);
            if (values.size() == 1) {
                this.restrictions.put(propInfo.getName(), values.get(0));
            } else {
                this.mvRestrictions.put(propInfo.getName(), values.toArray(new Value[0]));
            }
        }

        private void addRestrictions(List<PropInfo> propInfos) throws RepositoryException {
            for (PropInfo prop : propInfos) {
                this.addRestriction(prop);
            }
        }

        private void applyTo(JackrabbitAccessControlList acl) throws RepositoryException {
            Objects.requireNonNull(acl);
            if (!this.ignore) {
                acl.addEntry(this.principal, this.privileges.toArray(new Privilege[0]), this.isAllow, this.restrictions, this.mvRestrictions);
            } else {
                log.debug("Unknown principal: Ignore ACE based on ImportBehavior.IGNORE configuration.");
            }
        }
    }
}

