/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.commands.playwright;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.ConsoleMessage;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.impl.PlaywrightImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.launcher.commands.playwright.PlaywrightCommand;
import org.apache.tools.ant.Project;

public class DefaultPlaywrightCommand
implements PlaywrightCommand {
    private Project project;
    private String url;
    private File swf;
    private String browser;
    private String[] environment;
    private Playwright playwright;

    @Override
    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public File getSwf() {
        return this.swf;
    }

    @Override
    public void setSwf(File swf) {
        this.swf = swf;
    }

    @Override
    public void prepare() {
        Playwright.CreateOptions createOptions = new Playwright.CreateOptions();
        createOptions.setEnv(this.getEnvironmentMap());
        this.playwright = PlaywrightImpl.create((Playwright.CreateOptions)createOptions);
    }

    @Override
    public Playwright launch() throws IOException {
        LoggingUtil.log("Executing Playwright with " + this.browser);
        BrowserType browserType = null;
        switch (this.browser) {
            case "html": 
            case "chromium": {
                browserType = this.playwright.chromium();
                break;
            }
            case "webkit": {
                browserType = this.playwright.webkit();
                break;
            }
            case "firefox": {
                browserType = this.playwright.firefox();
                break;
            }
            default: {
                throw new IOException("Unknown browser: " + this.browser);
            }
        }
        Browser browserInstance = browserType.launch();
        Page page = browserInstance.newPage();
        page.onConsoleMessage((Consumer)new Consumer<ConsoleMessage>(){

            @Override
            public void accept(ConsoleMessage t) {
                switch (t.type()) {
                    case "error": {
                        LoggingUtil.error(t.text());
                        break;
                    }
                    default: {
                        LoggingUtil.log(t.text());
                    }
                }
            }
        });
        if (this.getUrl() != null) {
            page.navigate(this.getUrl());
        } else {
            page.navigate(this.swf.toURI().toString());
        }
        return this.playwright;
    }

    @Override
    public void setEnvironment(String[] variables) {
        this.environment = variables;
    }

    private Map<String, String> getEnvironmentMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.environment != null) {
            for (String envVar : this.environment) {
                String[] parts = envVar.split("=");
                result.put(parts[0].trim(), parts.length > 1 ? parts[1].trim() : "");
            }
        }
        return result;
    }
}

