/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetEventPriorities implements Message {

  // Properties.
  protected final BACnetOpeningTag openingTag;
  protected final BACnetApplicationTagUnsignedInteger toOffnormal;
  protected final BACnetApplicationTagUnsignedInteger toFault;
  protected final BACnetApplicationTagUnsignedInteger toNormal;
  protected final BACnetClosingTag closingTag;

  // Arguments.
  protected final Short tagNumber;

  public BACnetEventPriorities(
      BACnetOpeningTag openingTag,
      BACnetApplicationTagUnsignedInteger toOffnormal,
      BACnetApplicationTagUnsignedInteger toFault,
      BACnetApplicationTagUnsignedInteger toNormal,
      BACnetClosingTag closingTag,
      Short tagNumber) {
    super();
    this.openingTag = openingTag;
    this.toOffnormal = toOffnormal;
    this.toFault = toFault;
    this.toNormal = toNormal;
    this.closingTag = closingTag;
    this.tagNumber = tagNumber;
  }

  public BACnetOpeningTag getOpeningTag() {
    return openingTag;
  }

  public BACnetApplicationTagUnsignedInteger getToOffnormal() {
    return toOffnormal;
  }

  public BACnetApplicationTagUnsignedInteger getToFault() {
    return toFault;
  }

  public BACnetApplicationTagUnsignedInteger getToNormal() {
    return toNormal;
  }

  public BACnetClosingTag getClosingTag() {
    return closingTag;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetEventPriorities");

    // Simple Field (openingTag)
    writeSimpleField("openingTag", openingTag, writeComplex(writeBuffer));

    // Simple Field (toOffnormal)
    writeSimpleField("toOffnormal", toOffnormal, writeComplex(writeBuffer));

    // Simple Field (toFault)
    writeSimpleField("toFault", toFault, writeComplex(writeBuffer));

    // Simple Field (toNormal)
    writeSimpleField("toNormal", toNormal, writeComplex(writeBuffer));

    // Simple Field (closingTag)
    writeSimpleField("closingTag", closingTag, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetEventPriorities");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetEventPriorities _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (openingTag)
    lengthInBits += openingTag.getLengthInBits();

    // Simple field (toOffnormal)
    lengthInBits += toOffnormal.getLengthInBits();

    // Simple field (toFault)
    lengthInBits += toFault.getLengthInBits();

    // Simple field (toNormal)
    lengthInBits += toNormal.getLengthInBits();

    // Simple field (closingTag)
    lengthInBits += closingTag.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetEventPriorities staticParse(ReadBuffer readBuffer, Short tagNumber)
      throws ParseException {
    readBuffer.pullContext("BACnetEventPriorities");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetOpeningTag openingTag =
        readSimpleField(
            "openingTag",
            readComplex(
                () -> BACnetOpeningTag.staticParse(readBuffer, (short) (tagNumber)), readBuffer));

    BACnetApplicationTagUnsignedInteger toOffnormal =
        readSimpleField(
            "toOffnormal",
            readComplex(
                () ->
                    (BACnetApplicationTagUnsignedInteger)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    BACnetApplicationTagUnsignedInteger toFault =
        readSimpleField(
            "toFault",
            readComplex(
                () ->
                    (BACnetApplicationTagUnsignedInteger)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    BACnetApplicationTagUnsignedInteger toNormal =
        readSimpleField(
            "toNormal",
            readComplex(
                () ->
                    (BACnetApplicationTagUnsignedInteger)
                        BACnetApplicationTag.staticParse(readBuffer),
                readBuffer));

    BACnetClosingTag closingTag =
        readSimpleField(
            "closingTag",
            readComplex(
                () -> BACnetClosingTag.staticParse(readBuffer, (short) (tagNumber)), readBuffer));

    readBuffer.closeContext("BACnetEventPriorities");
    // Create the instance
    BACnetEventPriorities _bACnetEventPriorities;
    _bACnetEventPriorities =
        new BACnetEventPriorities(
            openingTag, toOffnormal, toFault, toNormal, closingTag, tagNumber);
    return _bACnetEventPriorities;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetEventPriorities)) {
      return false;
    }
    BACnetEventPriorities that = (BACnetEventPriorities) o;
    return (getOpeningTag() == that.getOpeningTag())
        && (getToOffnormal() == that.getToOffnormal())
        && (getToFault() == that.getToFault())
        && (getToNormal() == that.getToNormal())
        && (getClosingTag() == that.getClosingTag())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getOpeningTag(), getToOffnormal(), getToFault(), getToNormal(), getClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
