/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.prefs.Preferences;

public class WindowPrefs {
    private static final String KEY = "window_prefs_";
    private final Preferences pref;

    public WindowPrefs(Class<?> className) {
        this.pref = Preferences.userNodeForPackage(className);
    }

    public void setBounds(Rectangle rect) {
        Preferences node = this.pref.node(KEY);
        node.putInt("X", rect.x);
        node.putInt("Y", rect.y);
        node.putInt("W", rect.width);
        node.putInt("H", rect.height);
    }

    public Rectangle getBounds() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Preferences node = this.pref.node(KEY);
        int x = node.getInt("X", screenSize.width / 4);
        int y = node.getInt("Y", screenSize.height / 4);
        int w = node.getInt("W", screenSize.width / 2);
        int h = node.getInt("H", screenSize.height / 2);
        return new Rectangle(x, y, w, h);
    }

    public void setDividerLocation(int divider) {
        Preferences node = this.pref.node(KEY);
        node.putInt("DIV", divider);
    }

    public int getDividerLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Preferences node = this.pref.node(KEY);
        return node.getInt("DIV", screenSize.width / 8);
    }

    public void setExtendedState(int extendedState) {
        Preferences node = this.pref.node(KEY);
        node.putInt("EXTSTATE", extendedState);
    }

    public int getExtendedState() {
        Preferences node = this.pref.node(KEY);
        return node.getInt("EXTSTATE", 0);
    }
}

