/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.util.Arrays;
import org.flywaydb.core.api.FlywayException;

public enum ProvisionerMode {
    Provision("provision"),
    Reprovision("reprovision"),
    Skip("skip");

    private final String value;

    public static ProvisionerMode fromString(String value) {
        return Arrays.stream(ProvisionerMode.values()).filter(color -> color.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new FlywayException("Unknown provisioner mode: " + value));
    }

    public boolean isHigherPriorityThan(ProvisionerMode other) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Reprovision -> {
                if (other != Reprovision) {
                    yield true;
                }
                yield false;
            }
            case Provision -> {
                if (other == Skip) {
                    yield true;
                }
                yield false;
            }
            case Skip -> false;
        };
    }

    public String getValue() {
        return this.value;
    }

    private ProvisionerMode(String value) {
        this.value = value;
    }
}

