/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;

public class ProcessorsResult
extends AbstractWritableResult<ProcessorsEntity> {
    private final ProcessorsEntity processorsEntity;

    public ProcessorsResult(ResultType resultType, ProcessorsEntity processorsEntity) {
        super(resultType);
        this.processorsEntity = Objects.requireNonNull(processorsEntity);
    }

    @Override
    public ProcessorsEntity getResult() {
        return this.processorsEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Set processorsEntities = this.processorsEntity.getProcessors();
        if (processorsEntities == null) {
            return;
        }
        List processorDTOS = processorsEntities.stream().map(ProcessorEntity::getComponent).sorted(Comparator.comparing(ProcessorDTO::getName)).collect(Collectors.toList());
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 5, 40, true).column("ID", 36, 36, false).column("Type", 5, 40, true).column("Run Status", 10, 20, false).column("Version", 10, 20, false).build();
        for (int i = 0; i < processorDTOS.size(); ++i) {
            ProcessorDTO processorDTO = (ProcessorDTO)processorDTOS.get(i);
            String[] typeSplit = processorDTO.getType().split("\\.", -1);
            table.addRow(String.valueOf(i + 1), processorDTO.getName(), processorDTO.getId(), typeSplit[typeSplit.length - 1], processorDTO.getState(), processorDTO.getBundle().getVersion());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

