/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import io.grpc.EquivalentAddressGroup;
import io.grpc.xds.Endpoints;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsResourceType;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class XdsEndpointResource
extends XdsResourceType<EdsUpdate> {
    static final String ADS_TYPE_URL_EDS = "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment";
    private static final XdsEndpointResource instance = new XdsEndpointResource();

    XdsEndpointResource() {
    }

    public static XdsEndpointResource getInstance() {
        return instance;
    }

    @Override
    @Nullable
    protected String extractResourceName(Message unpackedResource) {
        if (!(unpackedResource instanceof ClusterLoadAssignment)) {
            return null;
        }
        return ((ClusterLoadAssignment)unpackedResource).getClusterName();
    }

    @Override
    protected String typeName() {
        return "EDS";
    }

    @Override
    protected String typeUrl() {
        return ADS_TYPE_URL_EDS;
    }

    @Override
    protected boolean isFullStateOfTheWorld() {
        return false;
    }

    @Override
    protected Class<ClusterLoadAssignment> unpackedClassName() {
        return ClusterLoadAssignment.class;
    }

    @Override
    protected EdsUpdate doParse(XdsResourceType.Args args, Message unpackedMessage) throws XdsResourceType.ResourceInvalidException {
        if (!(unpackedMessage instanceof ClusterLoadAssignment)) {
            throw new XdsResourceType.ResourceInvalidException("Invalid message type: " + unpackedMessage.getClass());
        }
        return XdsEndpointResource.processClusterLoadAssignment((ClusterLoadAssignment)unpackedMessage);
    }

    private static EdsUpdate processClusterLoadAssignment(ClusterLoadAssignment assignment) throws XdsResourceType.ResourceInvalidException {
        HashMap priorities = new HashMap();
        LinkedHashMap<io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap = new LinkedHashMap<io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints>();
        ArrayList<Endpoints.DropOverload> dropOverloads = new ArrayList<Endpoints.DropOverload>();
        int maxPriority = -1;
        for (LocalityLbEndpoints localityLbEndpointsProto : assignment.getEndpointsList()) {
            XdsResourceType.StructOrError<Endpoints.LocalityLbEndpoints> structOrError = XdsEndpointResource.parseLocalityLbEndpoints(localityLbEndpointsProto);
            if (structOrError == null) continue;
            if (structOrError.getErrorDetail() != null) {
                throw new XdsResourceType.ResourceInvalidException(structOrError.getErrorDetail());
            }
            Endpoints.LocalityLbEndpoints localityLbEndpoints = structOrError.getStruct();
            int priority = localityLbEndpoints.priority();
            maxPriority = Math.max(maxPriority, priority);
            io.grpc.xds.Locality locality = XdsEndpointResource.parseLocality(localityLbEndpointsProto.getLocality());
            localityLbEndpointsMap.put(locality, localityLbEndpoints);
            if (!priorities.containsKey(priority)) {
                priorities.put(priority, new HashSet());
            }
            if (((Set)priorities.get(priority)).add(locality)) continue;
            throw new XdsResourceType.ResourceInvalidException("ClusterLoadAssignment has duplicate locality:" + locality + " for priority:" + priority);
        }
        if (priorities.size() != maxPriority + 1) {
            throw new XdsResourceType.ResourceInvalidException("ClusterLoadAssignment has sparse priorities");
        }
        for (ClusterLoadAssignment.Policy.DropOverload dropOverloadProto : assignment.getPolicy().getDropOverloadsList()) {
            dropOverloads.add(XdsEndpointResource.parseDropOverload(dropOverloadProto));
        }
        return new EdsUpdate(assignment.getClusterName(), localityLbEndpointsMap, dropOverloads);
    }

    private static io.grpc.xds.Locality parseLocality(Locality proto) {
        return io.grpc.xds.Locality.create(proto.getRegion(), proto.getZone(), proto.getSubZone());
    }

    private static Endpoints.DropOverload parseDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
        return Endpoints.DropOverload.create(proto.getCategory(), XdsEndpointResource.getRatePerMillion(proto.getDropPercentage()));
    }

    private static int getRatePerMillion(FractionalPercent percent) {
        int numerator = percent.getNumerator();
        FractionalPercent.DenominatorType type = percent.getDenominator();
        switch (type) {
            case TEN_THOUSAND: {
                numerator *= 100;
                break;
            }
            case HUNDRED: {
                numerator *= 10000;
                break;
            }
            case MILLION: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown denominator type of " + percent);
            }
        }
        if (numerator > 1000000 || numerator < 0) {
            numerator = 1000000;
        }
        return numerator;
    }

    @Nullable
    @VisibleForTesting
    static XdsResourceType.StructOrError<Endpoints.LocalityLbEndpoints> parseLocalityLbEndpoints(LocalityLbEndpoints proto) {
        if (!proto.hasLoadBalancingWeight() || proto.getLoadBalancingWeight().getValue() < 1) {
            return null;
        }
        if (proto.getPriority() < 0) {
            return XdsResourceType.StructOrError.fromError("negative priority");
        }
        ArrayList<Endpoints.LbEndpoint> endpoints = new ArrayList<Endpoints.LbEndpoint>(proto.getLbEndpointsCount());
        for (LbEndpoint endpoint : proto.getLbEndpointsList()) {
            if (!endpoint.hasEndpoint() || !endpoint.getEndpoint().hasAddress()) {
                return XdsResourceType.StructOrError.fromError("LbEndpoint with no endpoint/address");
            }
            SocketAddress socketAddress = endpoint.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            boolean isHealthy = endpoint.getHealthStatus() == HealthStatus.HEALTHY || endpoint.getHealthStatus() == HealthStatus.UNKNOWN;
            endpoints.add(Endpoints.LbEndpoint.create(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), endpoint.getLoadBalancingWeight().getValue(), isHealthy));
        }
        return XdsResourceType.StructOrError.fromStruct(Endpoints.LocalityLbEndpoints.create(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority()));
    }

    static final class EdsUpdate
    implements XdsClient.ResourceUpdate {
        final String clusterName;
        final Map<io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap;
        final List<Endpoints.DropOverload> dropPolicies;

        EdsUpdate(String clusterName, Map<io.grpc.xds.Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints, List<Endpoints.DropOverload> dropPolicies) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.localityLbEndpointsMap = Collections.unmodifiableMap(new LinkedHashMap((Map)Preconditions.checkNotNull(localityLbEndpoints, (Object)"localityLbEndpoints")));
            this.dropPolicies = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(dropPolicies, (Object)"dropPolicies")));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdsUpdate that = (EdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.localityLbEndpointsMap, that.localityLbEndpointsMap) && Objects.equals(this.dropPolicies, that.dropPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.localityLbEndpointsMap, this.dropPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("localityLbEndpointsMap", this.localityLbEndpointsMap).add("dropPolicies", this.dropPolicies).toString();
        }
    }
}

