/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.VersionedComponent;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.nar.ExtensionManager;

public interface ControllerServiceNode
extends ComponentNode,
VersionedComponent,
GroupedComponent {
    @Override
    public ProcessGroup getProcessGroup();

    public void setProcessGroup(ProcessGroup var1);

    public ControllerService getProxiedControllerService();

    public ControllerServiceInvocationHandler getInvocationHandler();

    public List<ControllerServiceNode> getRequiredControllerServices();

    public ControllerService getControllerServiceImplementation();

    public ControllerServiceState getState();

    public CompletableFuture<Void> enable(ScheduledExecutorService var1, long var2);

    public CompletableFuture<Void> disable(ScheduledExecutorService var1);

    public ControllerServiceReference getReferences();

    public void addReference(ComponentNode var1, PropertyDescriptor var2);

    public void removeReference(ComponentNode var1, PropertyDescriptor var2);

    public void setComments(String var1);

    public String getComments();

    public void setBulletinLevel(LogLevel var1);

    public LogLevel getBulletinLevel();

    public void verifyCanEnable();

    public void verifyCanDisable();

    public void verifyCanDisable(Set<ControllerServiceNode> var1);

    public void verifyCanEnable(Set<ControllerServiceNode> var1);

    public void verifyCanDelete();

    public void verifyCanUpdate();

    public void verifyCanClearState();

    public boolean isActive();

    public boolean awaitEnabled(long var1, TimeUnit var3) throws InterruptedException;

    public boolean awaitDisabled(long var1, TimeUnit var3) throws InterruptedException;

    public void verifyCanPerformVerification();

    public List<ConfigVerificationResult> verifyConfiguration(ConfigurationContext var1, ComponentLog var2, Map<String, String> var3, ExtensionManager var4);

    public void setControllerServiceAndProxy(LoggableComponent<ControllerService> var1, LoggableComponent<ControllerService> var2, ControllerServiceInvocationHandler var3);

    public void notifyPrimaryNodeChanged(PrimaryNodeState var1);
}

