/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.connect;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.nifi.kafka.connect.StatelessNiFiCommonConfig;

public class StatelessNiFiSinkConfig
extends StatelessNiFiCommonConfig {
    public static final String INPUT_PORT_NAME = "input.port";
    public static final String FAILURE_PORTS = "failure.ports";
    public static final String HEADERS_AS_ATTRIBUTES_REGEX = "headers.as.attributes.regex";
    public static final String HEADER_ATTRIBUTE_NAME_PREFIX = "attribute.prefix";
    protected static final ConfigDef CONFIG_DEF = StatelessNiFiSinkConfig.createConfigDef();

    public StatelessNiFiSinkConfig(Map<?, ?> originals) {
        super(CONFIG_DEF, originals);
    }

    protected StatelessNiFiSinkConfig(ConfigDef definition, Map<?, ?> originals) {
        super(definition, originals);
    }

    public String getInputPortName() {
        return this.getString(INPUT_PORT_NAME);
    }

    public Set<String> getFailurePorts() {
        List configuredPorts = this.getList(FAILURE_PORTS);
        if (configuredPorts == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(configuredPorts);
    }

    public String getHeadersAsAttributesRegex() {
        return this.getString(HEADERS_AS_ATTRIBUTES_REGEX);
    }

    public String getHeaderAttributeNamePrefix() {
        return this.getString(HEADER_ATTRIBUTE_NAME_PREFIX);
    }

    protected static ConfigDef createConfigDef() {
        ConfigDef configDef = new ConfigDef();
        StatelessNiFiCommonConfig.addCommonConfigElements(configDef);
        StatelessNiFiSinkConfig.addFlowConfigs(configDef);
        StatelessNiFiSinkConfig.addSinkConfigs(configDef);
        return configDef;
    }

    protected static void addFlowConfigs(ConfigDef configDef) {
        StatelessNiFiCommonConfig.addFlowConfigElements(configDef);
        configDef.define(INPUT_PORT_NAME, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The name of the Input Port to push data to", "Flow", 100, ConfigDef.Width.NONE, "Input port name");
        configDef.define(FAILURE_PORTS, ConfigDef.Type.LIST, null, ConfigDef.Importance.MEDIUM, "A list of Output Ports that are considered failures. If any FlowFile is routed to an Output Ports whose name is provided in this property, the session is rolled back and is considered a failure", "Flow", 200, ConfigDef.Width.NONE, "Failure ports");
    }

    protected static void addSinkConfigs(ConfigDef configDef) {
        configDef.define(HEADERS_AS_ATTRIBUTES_REGEX, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "A regular expression to evaluate against Kafka message header keys. Any message header whose key matches the regular expression will be added to the FlowFile as an attribute. The name of the attribute will match the header key (with an optional prefix, as defined by the attribute.prefix configuration) and the header value will be added as the attribute value.", "Record", 0, ConfigDef.Width.NONE, "Headers as Attributes regex");
        configDef.define(HEADER_ATTRIBUTE_NAME_PREFIX, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "A prefix to add to the key of each header that matches the headers.as.attributes.regex Regular Expression. For example, if a header has the key MyHeader and a value of MyValue, and the headers.as.attributes.regex is set to My.* and this property is set to kafka. then the FlowFile that is created for the Kafka message will have an attribute named kafka.MyHeader with a value of MyValue.", "Record", 1, ConfigDef.Width.NONE, "Headers as Attributes prefix");
    }
}

