/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.endpoints;

import java.io.Closeable;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpointsDocument;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;
import org.apache.chemistry.opencmis.server.impl.endpoints.AbstractCmisEndpointsDocumentServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCmisEndpointsDocumentServlet
extends AbstractCmisEndpointsDocumentServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleCmisEndpointsDocumentServlet.class);
    private static final String PARAM_ENDPOINT_TEMPLATE = "template";
    private String endpointsDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        InputStream stream;
        block5: {
            super.init(config);
            String template = config.getInitParameter(PARAM_ENDPOINT_TEMPLATE);
            if (template == null) {
                LOG.error("CMIS Endpoints Document template provided!");
                return;
            }
            stream = null;
            try {
                stream = config.getServletContext().getResourceAsStream(template);
                if (stream == null) break block5;
                this.endpointsDocument = IOUtils.readAllLines((InputStream)stream);
            }
            catch (Exception e) {
                try {
                    LOG.error("Could not read CMIS Endpoints Document template from {}!", (Object)template, (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)stream);
            }
        }
        IOUtils.closeQuietly((Closeable)stream);
    }

    @Override
    public CmisEndpointsDocument getCmisEndpointsDocument(HttpServletRequest req, HttpServletResponse resp) {
        if (this.endpointsDocument == null) {
            return null;
        }
        UrlBuilder url = new UrlBuilder(req.getScheme(), req.getServerName(), req.getServerPort(), null);
        url.addPath(req.getContextPath());
        try {
            return this.readCmisEndpointsDocument(this.endpointsDocument.replaceAll("\\{webapp\\}", url.toString()));
        }
        catch (JSONParseException e) {
            LOG.error("Invalid JSON!", (Throwable)e);
            return null;
        }
    }
}

