/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.remote.http.AbstractHttpCommandCodec;

public class JsonHttpCommandCodec
extends AbstractHttpCommandCodec {
    public JsonHttpCommandCodec() {
        this.defineCommand("getElementAttribute", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/attribute/:name"));
        this.defineCommand("getElementLocationOnceScrolledIntoView", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/location_in_view"));
        this.defineCommand("isElementDisplayed", JsonHttpCommandCodec.get("/session/:sessionId/element/:id/displayed"));
        this.defineCommand("submitElement", JsonHttpCommandCodec.post("/session/:sessionId/element/:id/submit"));
        this.defineCommand("executeScript", JsonHttpCommandCodec.post("/session/:sessionId/execute"));
        this.defineCommand("executeAsyncScript", JsonHttpCommandCodec.post("/session/:sessionId/execute_async"));
        this.defineCommand("getPageSource", JsonHttpCommandCodec.get("/session/:sessionId/source"));
        this.defineCommand("maximizeCurrentWindow", JsonHttpCommandCodec.post("/session/:sessionId/window/:windowHandle/maximize"));
        this.defineCommand("getWindowPosition", JsonHttpCommandCodec.get("/session/:sessionId/window/:windowHandle/position"));
        this.defineCommand("setWindowPosition", JsonHttpCommandCodec.post("/session/:sessionId/window/:windowHandle/position"));
        this.defineCommand("getCurrentWindowSize", JsonHttpCommandCodec.get("/session/:sessionId/window/:windowHandle/size"));
        this.defineCommand("setCurrentWindowSize", JsonHttpCommandCodec.post("/session/:sessionId/window/:windowHandle/size"));
        this.defineCommand("getCurrentWindowHandle", JsonHttpCommandCodec.get("/session/:sessionId/window_handle"));
        this.defineCommand("getWindowHandles", JsonHttpCommandCodec.get("/session/:sessionId/window_handles"));
        this.defineCommand("acceptAlert", JsonHttpCommandCodec.post("/session/:sessionId/accept_alert"));
        this.defineCommand("dismissAlert", JsonHttpCommandCodec.post("/session/:sessionId/dismiss_alert"));
        this.defineCommand("getAlertText", JsonHttpCommandCodec.get("/session/:sessionId/alert_text"));
        this.defineCommand("setAlertValue", JsonHttpCommandCodec.post("/session/:sessionId/alert_text"));
        this.defineCommand("getActiveElement", JsonHttpCommandCodec.post("/session/:sessionId/element/active"));
        this.defineCommand("clearLocalStorage", JsonHttpCommandCodec.delete("/session/:sessionId/local_storage"));
        this.defineCommand("getLocalStorageKeys", JsonHttpCommandCodec.get("/session/:sessionId/local_storage"));
        this.defineCommand("setLocalStorageItem", JsonHttpCommandCodec.post("/session/:sessionId/local_storage"));
        this.defineCommand("removeLocalStorageItem", JsonHttpCommandCodec.delete("/session/:sessionId/local_storage/key/:key"));
        this.defineCommand("getLocalStorageItem", JsonHttpCommandCodec.get("/session/:sessionId/local_storage/key/:key"));
        this.defineCommand("getLocalStorageSize", JsonHttpCommandCodec.get("/session/:sessionId/local_storage/size"));
        this.defineCommand("clearSessionStorage", JsonHttpCommandCodec.delete("/session/:sessionId/session_storage"));
        this.defineCommand("getSessionStorageKey", JsonHttpCommandCodec.get("/session/:sessionId/session_storage"));
        this.defineCommand("setSessionStorageItem", JsonHttpCommandCodec.post("/session/:sessionId/session_storage"));
        this.defineCommand("removeSessionStorageItem", JsonHttpCommandCodec.delete("/session/:sessionId/session_storage/key/:key"));
        this.defineCommand("getSessionStorageItem", JsonHttpCommandCodec.get("/session/:sessionId/session_storage/key/:key"));
        this.defineCommand("getSessionStorageSize", JsonHttpCommandCodec.get("/session/:sessionId/session_storage/size"));
        this.defineCommand("mouseButtonDown", JsonHttpCommandCodec.post("/session/:sessionId/buttondown"));
        this.defineCommand("mouseButtonUp", JsonHttpCommandCodec.post("/session/:sessionId/buttonup"));
        this.defineCommand("mouseClick", JsonHttpCommandCodec.post("/session/:sessionId/click"));
        this.defineCommand("mouseDoubleClick", JsonHttpCommandCodec.post("/session/:sessionId/doubleclick"));
        this.defineCommand("mouseMoveTo", JsonHttpCommandCodec.post("/session/:sessionId/moveto"));
        this.defineCommand("sendKeysToActiveElement", JsonHttpCommandCodec.post("/session/:sessionId/keys"));
        this.defineCommand("touchSingleTap", JsonHttpCommandCodec.post("/session/:sessionId/touch/click"));
        this.defineCommand("touchDoubleTap", JsonHttpCommandCodec.post("/session/:sessionId/touch/doubleclick"));
        this.defineCommand("touchDown", JsonHttpCommandCodec.post("/session/:sessionId/touch/down"));
        this.defineCommand("touchFlick", JsonHttpCommandCodec.post("/session/:sessionId/touch/flick"));
        this.defineCommand("touchLongPress", JsonHttpCommandCodec.post("/session/:sessionId/touch/longclick"));
        this.defineCommand("touchMove", JsonHttpCommandCodec.post("/session/:sessionId/touch/move"));
        this.defineCommand("touchScroll", JsonHttpCommandCodec.post("/session/:sessionId/touch/scroll"));
        this.defineCommand("touchUp", JsonHttpCommandCodec.post("/session/:sessionId/touch/up"));
    }

    @Override
    protected Map<String, ?> amendParameters(String name, Map<String, ?> parameters) {
        switch (name) {
            case "getCurrentWindowSize": 
            case "maximizeCurrentWindow": 
            case "setCurrentWindowSize": 
            case "setWindowPosition": {
                return ImmutableMap.builder().putAll(parameters).put((Object)"windowHandle", (Object)"current").put((Object)"handle", (Object)"current").build();
            }
            case "setTimeout": {
                if (parameters.size() != 1) {
                    throw new InvalidArgumentException("The JSON wire protocol only supports setting one time out at a time");
                }
                Map.Entry<String, ?> entry = parameters.entrySet().iterator().next();
                String type = entry.getKey();
                if ("pageLoad".equals(type)) {
                    type = "page load";
                }
                return ImmutableMap.of((Object)"type", (Object)type, (Object)"ms", entry.getValue());
            }
            case "switchToWindow": {
                return ImmutableMap.builder().put((Object)"name", parameters.get("handle")).build();
            }
        }
        return parameters;
    }
}

