/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class RescoreBuilder
implements ToXContent {
    private Rescorer rescorer;
    private Integer windowSize;

    public static QueryRescorer queryRescorer(QueryBuilder queryBuilder) {
        return new QueryRescorer(queryBuilder);
    }

    public RescoreBuilder rescorer(Rescorer rescorer) {
        this.rescorer = rescorer;
        return this;
    }

    public RescoreBuilder windowSize(int windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.rescorer != null) {
            builder.startObject("rescore");
            if (this.windowSize != null) {
                builder.field("window_size", this.windowSize);
            }
            this.rescorer.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public static class QueryRescorer
    extends Rescorer {
        private static final String NAME = "query";
        private QueryBuilder queryBuilder;
        private Float rescoreQueryWeight;
        private Float queryWeight;
        private String scoreMode;

        public QueryRescorer(QueryBuilder builder) {
            super(NAME);
            this.queryBuilder = builder;
        }

        public QueryRescorer setQueryWeight(float queryWeight) {
            this.queryWeight = Float.valueOf(queryWeight);
            return this;
        }

        public QueryRescorer setRescoreQueryWeight(float rescoreQueryWeight) {
            this.rescoreQueryWeight = Float.valueOf(rescoreQueryWeight);
            return this;
        }

        public QueryRescorer setScoreMode(String scoreMode) {
            this.scoreMode = scoreMode;
            return this;
        }

        @Override
        protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("rescore_query", this.queryBuilder);
            if (this.queryWeight != null) {
                builder.field("query_weight", this.queryWeight);
            }
            if (this.rescoreQueryWeight != null) {
                builder.field("rescore_query_weight", this.rescoreQueryWeight);
            }
            if (this.scoreMode != null) {
                builder.field("score_mode", this.scoreMode);
            }
            return builder;
        }
    }

    public static abstract class Rescorer
    implements ToXContent {
        private String name;

        public Rescorer(String name) {
            this.name = name;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name);
            builder = this.innerToXContent(builder, params);
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
    }
}

