/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxCountersTable;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import reactor.core.publisher.Mono;

public class CassandraMailboxCounterDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement readStatement;
    private final PreparedStatement incrementUnseenCountStatement;
    private final PreparedStatement incrementMessageCountStatement;
    private final PreparedStatement addToCounters;
    private final PreparedStatement removeToCounters;
    private final PreparedStatement decrementUnseenCountStatement;
    private final PreparedStatement decrementMessageCountStatement;
    private final PreparedStatement incrementUnseenAndCountStatement;
    private final PreparedStatement decrementUnseenAndCountStatement;
    private final PreparedStatement deleteStatement;

    @Inject
    public CassandraMailboxCounterDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.readStatement = this.createReadStatement(session);
        this.incrementMessageCountStatement = this.updateMailboxStatement(session, Assignment.increment((CqlIdentifier)CassandraMailboxCountersTable.COUNT));
        this.incrementUnseenCountStatement = this.updateMailboxStatement(session, Assignment.increment((CqlIdentifier)CassandraMailboxCountersTable.UNSEEN));
        this.addToCounters = session.prepare(((Update)QueryBuilder.update((String)"mailboxCounters").increment(CassandraMailboxCountersTable.COUNT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.COUNT)).increment(CassandraMailboxCountersTable.UNSEEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.UNSEEN)).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID)))).build());
        this.removeToCounters = session.prepare(((Update)QueryBuilder.update((String)"mailboxCounters").decrement(CassandraMailboxCountersTable.COUNT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.COUNT)).decrement(CassandraMailboxCountersTable.UNSEEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.UNSEEN)).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID)))).build());
        this.decrementMessageCountStatement = this.updateMailboxStatement(session, Assignment.decrement((CqlIdentifier)CassandraMailboxCountersTable.COUNT));
        this.decrementUnseenCountStatement = this.updateMailboxStatement(session, Assignment.decrement((CqlIdentifier)CassandraMailboxCountersTable.UNSEEN));
        this.incrementUnseenAndCountStatement = session.prepare(((Update)QueryBuilder.update((String)"mailboxCounters").increment(CassandraMailboxCountersTable.COUNT).increment(CassandraMailboxCountersTable.UNSEEN).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID)))).build());
        this.decrementUnseenAndCountStatement = session.prepare(((Update)QueryBuilder.update((String)"mailboxCounters").decrement(CassandraMailboxCountersTable.COUNT).decrement(CassandraMailboxCountersTable.UNSEEN).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID)))).build());
        this.deleteStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"mailboxCounters").where((Relation)Relation.column((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement createReadStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"mailboxCounters").columns(new CqlIdentifier[]{CassandraMailboxCountersTable.UNSEEN, CassandraMailboxCountersTable.COUNT}).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement updateMailboxStatement(CqlSession session, Assignment operation) {
        return session.prepare(((Update)QueryBuilder.update((String)"mailboxCounters").set(operation).where((Relation)Relation.column((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMailboxCountersTable.MAILBOX_ID)))).build());
    }

    public Mono<Void> delete(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.deleteStatement));
    }

    public Mono<MailboxCounters> retrieveMailboxCounters(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.bindWithMailbox(mailboxId, this.readStatement)).map(row -> MailboxCounters.builder().mailboxId((MailboxId)mailboxId).count(row.getLong(CassandraMailboxCountersTable.COUNT)).unseen(row.getLong(CassandraMailboxCountersTable.UNSEEN)).build());
    }

    public Mono<Void> resetCounters(MailboxCounters counters) {
        CassandraId mailboxId = (CassandraId)counters.getMailboxId();
        return this.retrieveMailboxCounters(mailboxId).defaultIfEmpty((Object)MailboxCounters.empty((MailboxId)mailboxId)).flatMap(storedCounters -> {
            if (storedCounters.equals((Object)counters)) {
                return Mono.empty();
            }
            return this.remove((MailboxCounters)storedCounters).then(this.add(counters));
        });
    }

    public Mono<Void> add(MailboxCounters counters) {
        CassandraId mailboxId = (CassandraId)counters.getMailboxId();
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.bindWithMailbox(mailboxId, this.addToCounters).setLong(CassandraMailboxCountersTable.COUNT, counters.getCount())).setLong(CassandraMailboxCountersTable.UNSEEN, counters.getUnseen()));
    }

    public Mono<Void> remove(MailboxCounters counters) {
        CassandraId mailboxId = (CassandraId)counters.getMailboxId();
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.bindWithMailbox(mailboxId, this.removeToCounters).setLong(CassandraMailboxCountersTable.COUNT, counters.getCount())).setLong(CassandraMailboxCountersTable.UNSEEN, counters.getUnseen()));
    }

    public Mono<Long> countMessagesInMailbox(Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.countMessagesInMailbox(mailboxId);
    }

    public Mono<Long> countMessagesInMailbox(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.bindWithMailbox(cassandraId, this.readStatement)).map(row -> row.getLong(CassandraMailboxCountersTable.COUNT));
    }

    public Mono<Long> countUnseenMessagesInMailbox(Mailbox mailbox) {
        CassandraId mailboxId = (CassandraId)mailbox.getMailboxId();
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.bindWithMailbox(mailboxId, this.readStatement)).map(row -> row.getLong(CassandraMailboxCountersTable.UNSEEN));
    }

    public Mono<Void> decrementCount(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.decrementMessageCountStatement));
    }

    public Mono<Void> incrementCount(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.incrementMessageCountStatement));
    }

    public Mono<Void> decrementUnseen(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.decrementUnseenCountStatement));
    }

    public Mono<Void> incrementUnseen(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.incrementUnseenCountStatement));
    }

    public Mono<Void> decrementUnseenAndCount(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.decrementUnseenAndCountStatement));
    }

    public Mono<Void> incrementUnseenAndCount(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.bindWithMailbox(mailboxId, this.incrementUnseenAndCountStatement));
    }

    public Mono<Void> incrementUnseenAndCount(CassandraId mailboxId, long count, long unseen) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.bindWithMailbox(mailboxId, this.addToCounters).setLong(CassandraMailboxCountersTable.COUNT, count)).setLong(CassandraMailboxCountersTable.UNSEEN, unseen));
    }

    private BoundStatement bindWithMailbox(CassandraId mailboxId, PreparedStatement statement) {
        return (BoundStatement)statement.bind(new Object[0]).set(CassandraMailboxCountersTable.MAILBOX_ID, (Object)mailboxId.asUuid(), TypeCodecs.TIMEUUID);
    }
}

