/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.ReactorUtils;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.MetadataSerializer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MetadataDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement removeStatement;
    private final PreparedStatement removeAllStatement;
    private final PreparedStatement readStatement;
    private final PreparedStatement readMessageIdStatement;
    private final MessageId.Factory messageIdFactory;
    private final MetadataSerializer metadataSerializer;

    @Inject
    MetadataDAO(Session session, MessageId.Factory messageIdFactory, MetadataSerializer metadataSerializer) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAdd(session);
        this.removeStatement = this.prepareRemove(session);
        this.removeAllStatement = this.prepareRemoveAll(session);
        this.readStatement = this.prepareRead(session, "payload");
        this.readMessageIdStatement = this.prepareRead(session, "messageId");
        this.messageIdFactory = messageIdFactory;
        this.metadataSerializer = metadataSerializer;
    }

    private PreparedStatement prepareRead(Session session, String fieldName) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{fieldName}).from("deletedMessageMetadata").where(QueryBuilder.eq((String)"bucketName", (Object)QueryBuilder.bindMarker((String)"bucketName"))).and(QueryBuilder.eq((String)"owner", (Object)QueryBuilder.bindMarker((String)"owner"))));
    }

    private PreparedStatement prepareAdd(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"deletedMessageMetadata").value("bucketName", (Object)QueryBuilder.bindMarker((String)"bucketName")).value("owner", (Object)QueryBuilder.bindMarker((String)"owner")).value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("payload", (Object)QueryBuilder.bindMarker((String)"payload")));
    }

    private PreparedStatement prepareRemove(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("deletedMessageMetadata").where(QueryBuilder.eq((String)"owner", (Object)QueryBuilder.bindMarker((String)"owner"))).and(QueryBuilder.eq((String)"bucketName", (Object)QueryBuilder.bindMarker((String)"bucketName"))).and(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
    }

    private PreparedStatement prepareRemoveAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("deletedMessageMetadata").where(QueryBuilder.eq((String)"owner", (Object)QueryBuilder.bindMarker((String)"owner"))).and(QueryBuilder.eq((String)"bucketName", (Object)QueryBuilder.bindMarker((String)"bucketName"))));
    }

    Mono<Void> store(DeletedMessageWithStorageInformation metadata) {
        return Mono.just((Object)metadata).map(this.metadataSerializer::serialize).flatMap(payload -> this.cassandraAsyncExecutor.executeVoid((Statement)this.addStatement.bind().setString("bucketName", metadata.getStorageInformation().getBucketName().asString()).setString("owner", metadata.getDeletedMessage().getOwner().asString()).setString("messageId", metadata.getDeletedMessage().getMessageId().serialize()).setString("payload", payload)));
    }

    Flux<DeletedMessageWithStorageInformation> retrieveMetadata(BucketName bucketName, Username username) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.readStatement.bind().setString("bucketName", bucketName.asString()).setString("owner", username.asString())).map(row -> row.getString("payload")).map(this.metadataSerializer::deserialize).handle(ReactorUtils.publishIfPresent());
    }

    Flux<MessageId> retrieveMessageIds(BucketName bucketName, Username username) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.readMessageIdStatement.bind().setString("bucketName", bucketName.asString()).setString("owner", username.asString())).map(row -> row.getString("messageId")).map(arg_0 -> ((MessageId.Factory)this.messageIdFactory).fromString(arg_0));
    }

    Mono<Void> deleteMessage(BucketName bucketName, Username username, MessageId messageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.removeStatement.bind().setString("bucketName", bucketName.asString()).setString("owner", username.asString()).setString("messageId", messageId.serialize()));
    }

    Mono<Void> deleteInBucket(BucketName bucketName, Username username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.removeAllStatement.bind().setString("bucketName", bucketName.asString()).setString("owner", username.asString()));
    }
}

