/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.versions;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.UUIDs;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import reactor.core.publisher.Mono;

public class CassandraSchemaVersionDAO {
    private final PreparedStatement readVersionStatement;
    private final PreparedStatement writeVersionStatement;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;

    @Inject
    public CassandraSchemaVersionDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.readVersionStatement = this.prepareReadVersionStatement(session);
        this.writeVersionStatement = this.prepareWriteVersionStatement(session);
    }

    private PreparedStatement prepareReadVersionStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"value"}).from("schemaVersion"));
    }

    private PreparedStatement prepareWriteVersionStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"schemaVersion").value("key", (Object)QueryBuilder.bindMarker((String)"key")).value("value", (Object)QueryBuilder.bindMarker((String)"value")));
    }

    public Mono<Optional<SchemaVersion>> getCurrentSchemaVersion() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.readVersionStatement.bind()).map(row -> row.getInt("value")).reduce(Math::max).map(SchemaVersion::new).map(Optional::of).defaultIfEmpty(Optional.empty());
    }

    public Mono<Void> updateVersion(SchemaVersion newVersion) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.writeVersionStatement.bind().setUUID("key", UUIDs.timeBased()).setInt("value", newVersion.getValue()));
    }

    @VisibleForTesting
    public Mono<Void> truncateVersion() {
        return this.cassandraAsyncExecutor.executeVoid((Statement)QueryBuilder.truncate((String)"schemaVersion"));
    }
}

