/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class StreamFileValuePatternReaderThread
extends Thread {
    @NotNull
    private final AtomicLong nextLineNumber;
    @NotNull
    private final AtomicReference<BufferedReader> fileReader;
    @NotNull
    private final AtomicReference<StreamFileValuePatternReaderThread> threadRef;
    @NotNull
    private final File file;
    @NotNull
    private final LinkedBlockingQueue<String> lineQueue;
    private final long maxOfferBlockTimeMillis;

    StreamFileValuePatternReaderThread(@NotNull File file, @NotNull LinkedBlockingQueue<String> lineQueue, long maxOfferBlockTimeMillis, @NotNull AtomicLong nextLineNumber, @NotNull AtomicReference<StreamFileValuePatternReaderThread> threadRef) throws IOException {
        this.setName("StreamFileValuePatternReaderThread for file '" + file.getAbsolutePath() + '\'');
        this.setDaemon(true);
        this.file = file;
        this.lineQueue = lineQueue;
        this.maxOfferBlockTimeMillis = maxOfferBlockTimeMillis;
        this.nextLineNumber = nextLineNumber;
        this.threadRef = threadRef;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        this.fileReader = new AtomicReference<BufferedReader>(bufferedReader);
        long linesToSkip = nextLineNumber.get();
        for (long i = 0L; i < linesToSkip && bufferedReader.readLine() != null; ++i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        BufferedReader bufferedReader = this.fileReader.get();
        try {
            while (true) {
                String line;
                try {
                    while ((line = bufferedReader.readLine()) == null) {
                        this.nextLineNumber.set(0L);
                        bufferedReader.close();
                        bufferedReader = new BufferedReader(new FileReader(this.file));
                        this.fileReader.set(bufferedReader);
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.nextLineNumber.set(0L);
                    this.threadRef.set(null);
                    try {
                        bufferedReader.close();
                        return;
                    }
                    catch (Exception e2) {
                        Debug.debugException(e2);
                        return;
                    }
                    finally {
                        this.fileReader.set(null);
                    }
                }
                if (!this.lineQueue.offer(line, this.maxOfferBlockTimeMillis, TimeUnit.MILLISECONDS)) return;
                this.nextLineNumber.incrementAndGet();
            }
        }
        finally {
            this.threadRef.set(null);
            try {
                bufferedReader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            finally {
                this.fileReader.set(null);
            }
        }
    }
}

