/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address;

import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Group;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.field.address.AddressListParser;
import org.apache.james.mime4j.field.address.AddressParser;
import org.apache.james.mime4j.field.address.Builder;
import org.apache.james.mime4j.field.address.ParseException;
import org.apache.james.mime4j.io.InputStreams;

public class DefaultAddressParser
implements AddressParser {
    public static final DefaultAddressParser DEFAULT = new DefaultAddressParser();

    protected DefaultAddressParser() {
    }

    public Address parseAddress(CharSequence text, DecodeMonitor monitor) throws ParseException {
        AddressListParser parser = new AddressListParser(InputStreams.create(text, Charsets.UTF_8));
        return Builder.getInstance().buildAddress(parser.parseAddress(), monitor);
    }

    public Address parseAddress(CharSequence text) throws ParseException {
        return this.parseAddress(text, DecodeMonitor.STRICT);
    }

    public AddressList parseAddressList(CharSequence text, DecodeMonitor monitor) throws ParseException {
        AddressListParser parser = new AddressListParser(InputStreams.create(text, Charsets.UTF_8));
        return Builder.getInstance().buildAddressList(parser.parseAddressList(), monitor);
    }

    public AddressList parseAddressList(CharSequence text) throws ParseException {
        return this.parseAddressList(text, DecodeMonitor.STRICT);
    }

    public Mailbox parseMailbox(CharSequence text, DecodeMonitor monitor) throws ParseException {
        AddressListParser parser = new AddressListParser(InputStreams.create(text, Charsets.UTF_8));
        return Builder.getInstance().buildMailbox(parser.parseMailbox(), monitor);
    }

    public Mailbox parseMailbox(CharSequence text) throws ParseException {
        return this.parseMailbox(text, DecodeMonitor.STRICT);
    }

    public Group parseGroup(CharSequence text, DecodeMonitor monitor) throws ParseException {
        Address address = this.parseAddress(text, monitor);
        if (!(address instanceof Group)) {
            throw new ParseException("Not a group address");
        }
        return (Group)address;
    }

    public Group parseGroup(CharSequence text) throws ParseException {
        return this.parseGroup(text, DecodeMonitor.STRICT);
    }
}

