/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InListExpression
extends Expression {
    private final List<Expression> values;

    public InListExpression(List<Expression> values) {
        super(null);
        Objects.requireNonNull(values, "values is null");
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)"values cannot be empty");
        this.values = ImmutableList.copyOf(values);
    }

    public InListExpression(NodeLocation location, List<Expression> values) {
        super(Objects.requireNonNull(location, "location is null"));
        Objects.requireNonNull(values, "values is null");
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)"values cannot be empty");
        this.values = ImmutableList.copyOf(values);
    }

    public InListExpression(ByteBuffer byteBuffer) {
        super(null);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.values = new ArrayList<Expression>();
        for (int i = 0; i < size; ++i) {
            this.values.add(Expression.deserialize(byteBuffer));
        }
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.IN_LIST;
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.values.size(), (OutputStream)stream);
        for (Expression expression : this.values) {
            Expression.serialize(expression, stream);
        }
    }

    public List<Expression> getValues() {
        return this.values;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitInListExpression(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InListExpression that = (InListExpression)o;
        return Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return InListExpression.sameClass(this, other);
    }
}

