/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSchema {
    private final String tableName;
    protected final List<ColumnSchema> columns;
    protected Map<String, String> props;
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSchema.class);

    public TableSchema(String tableName, List<ColumnSchema> columns) {
        this.tableName = tableName;
        this.columns = columns;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnSchema> getColumns() {
        return this.columns;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public ColumnSchema getColumn(String columnName, TsTableColumnCategory columnCategory) {
        return this.columns.stream().filter(column -> column.getName().equals(columnName) && column.getColumnCategory() == columnCategory).findAny().orElse(null);
    }

    public int getIndexAmongIdColumns(String idColumnName) {
        int index = 0;
        for (ColumnSchema column : this.getIdColumns()) {
            if (column.getName().equals(idColumnName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static TableSchema of(TsTable tsTable) {
        TableSchema schema = new TableSchema(tsTable.getTableName(), tsTable.getColumnList().stream().map(ColumnSchema::ofTsColumnSchema).collect(Collectors.toList()));
        schema.setProps(tsTable.getProps());
        return schema;
    }

    public org.apache.tsfile.file.metadata.TableSchema toTsFileTableSchema() {
        String tableName = this.getTableName();
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
        ArrayList<ColumnCategory> columnTypes = new ArrayList<ColumnCategory>();
        for (ColumnSchema column : this.columns) {
            if (column.getColumnCategory() == TsTableColumnCategory.TIME) continue;
            measurementSchemas.add(new MeasurementSchema(column.getName(), InternalTypeManager.getTSDataType(column.getType())));
            columnTypes.add(column.getColumnCategory().toTsFileColumnType());
        }
        return new org.apache.tsfile.file.metadata.TableSchema(tableName, measurementSchemas, columnTypes);
    }

    public org.apache.tsfile.file.metadata.TableSchema toTsFileTableSchemaNoAttribute() {
        String tableName = this.getTableName();
        ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
        ArrayList<ColumnCategory> columnTypes = new ArrayList<ColumnCategory>();
        for (ColumnSchema column : this.columns) {
            if (column.getColumnCategory() == TsTableColumnCategory.TIME || column.getColumnCategory() == TsTableColumnCategory.ATTRIBUTE) continue;
            measurementSchemas.add(new MeasurementSchema(column.getName(), InternalTypeManager.getTSDataType(column.getType())));
            columnTypes.add(column.getColumnCategory().toTsFileColumnType());
        }
        return new org.apache.tsfile.file.metadata.TableSchema(tableName, measurementSchemas, columnTypes);
    }

    public static TableSchema fromTsFileTableSchema(String tableName, org.apache.tsfile.file.metadata.TableSchema tsFileTableSchema) {
        try {
            ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
            for (int i = 0; i < tsFileTableSchema.getColumnSchemas().size(); ++i) {
                TSDataType dataType;
                ColumnCategory columnType;
                String columnName = ((IMeasurementSchema)tsFileTableSchema.getColumnSchemas().get(i)).getMeasurementName();
                if (columnName == null || columnName.isEmpty() || (columnType = (ColumnCategory)tsFileTableSchema.getColumnTypes().get(i)) == ColumnCategory.ATTRIBUTE || (dataType = ((IMeasurementSchema)tsFileTableSchema.getColumnSchemas().get(i)).getType()) == TSDataType.VECTOR) continue;
                columns.add(new ColumnSchema(columnName, InternalTypeManager.fromTSDataType(dataType), false, TsTableColumnCategory.fromTsFileColumnCategory((ColumnCategory)columnType)));
            }
            return new TableSchema(tableName, columns);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot convert tsfile table schema to iotdb table schema, table name: {}, tsfile table schema: {}", new Object[]{tableName, tsFileTableSchema, e});
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema that = (TableSchema)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.columns);
    }

    public String toString() {
        return "TableSchema{tableName='" + this.tableName + '\'' + ", columns=" + this.columns + '}';
    }

    public List<ColumnSchema> getIdColumns() {
        return this.columns.stream().filter(c -> c.getColumnCategory() == TsTableColumnCategory.TAG).collect(Collectors.toList());
    }
}

